/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<? extends OsmPrimitive> conflict;
    private final List<TagMergeItem> mergeItems;

    public int getNumDecidedConflicts() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public TagConflictResolveCommand(Conflict<? extends OsmPrimitive> conflict, List<TagMergeItem> list) {
        this.conflict = conflict;
        this.mergeItems = list;
    }

    @Override
    public String getDescriptionText() {
        String string = "";
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                string = I18n.marktr("Resolve {0} tag conflicts in node {1}");
                break;
            }
            case WAY: {
                string = I18n.marktr("Resolve {0} tag conflicts in way {1}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("Resolve {0} tag conflicts in relation {1}");
            }
        }
        return I18n.tr(string, this.getNumDecidedConflicts(), this.conflict.getMy().getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (TagMergeItem tagMergeItem : this.mergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            tagMergeItem.applyToMyPrimitive(this.conflict.getMy());
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.conflict.getMy());
    }
}

