/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimitivesCommand
extends Command {
    private List<PrimitiveData> data = new ArrayList<PrimitiveData>();
    private List<OsmPrimitive> createdPrimitives = null;

    public AddPrimitivesCommand(List<PrimitiveData> list) {
        this.data.addAll(list);
    }

    public AddPrimitivesCommand(List<PrimitiveData> list, OsmDataLayer osmDataLayer) {
        super(osmDataLayer);
        this.data.addAll(list);
    }

    @Override
    public boolean executeCommand() {
        List<Object> list;
        if (this.createdPrimitives == null) {
            list = new ArrayList(this.data.size());
            for (PrimitiveData primitiveData : this.data) {
                boolean bl;
                OsmPrimitive osmPrimitive = this.getLayer().data.getPrimitiveById(primitiveData);
                boolean bl2 = bl = osmPrimitive == null;
                if (bl) {
                    osmPrimitive = primitiveData.getType().newInstance(primitiveData.getUniqueId(), true);
                }
                if (primitiveData instanceof NodeData) {
                    osmPrimitive.load(primitiveData);
                }
                if (bl) {
                    this.getLayer().data.addPrimitive(osmPrimitive);
                }
                list.add(osmPrimitive);
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof Node) continue;
                ((OsmPrimitive)list.get(i)).load(this.data.get(i));
            }
        } else {
            for (OsmPrimitive osmPrimitive : this.createdPrimitives) {
                this.getLayer().data.addPrimitive(osmPrimitive);
            }
            list = this.createdPrimitives;
        }
        this.getLayer().data.setSelected(list);
        return true;
    }

    @Override
    public void undoCommand() {
        DataSet dataSet = this.getLayer().data;
        if (this.createdPrimitives == null) {
            this.createdPrimitives = new ArrayList<OsmPrimitive>(this.data.size());
            for (PrimitiveData primitiveData : this.data) {
                this.createdPrimitives.add(dataSet.getPrimitiveById(primitiveData));
            }
            this.createdPrimitives = PurgeCommand.topoSort(this.createdPrimitives);
            for (PrimitiveData primitiveData : this.data) {
                dataSet.removePrimitive(primitiveData);
            }
            this.data = null;
        } else {
            for (OsmPrimitive osmPrimitive : this.createdPrimitives) {
                dataSet.removePrimitive(osmPrimitive);
            }
        }
    }

    @Override
    public String getDescriptionText() {
        int n = this.data != null ? this.data.size() : this.createdPrimitives.size();
        return I18n.trn("Added {0} object", "Added {0} objects", n, n);
    }

    @Override
    public Icon getDescriptionIcon() {
        return null;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        if (this.createdPrimitives != null) {
            return this.createdPrimitives;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (PrimitiveData primitiveData : this.data) {
            OsmPrimitive osmPrimitive = this.getLayer().data.getPrimitiveById(primitiveData);
            if (osmPrimitive == null) {
                throw new RuntimeException();
            }
            hashSet.add(osmPrimitive);
        }
        return hashSet;
    }
}

