/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import org.openstreetmap.josm.tools.template_engine.StaticText;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class CompoundTemplateEntry
implements TemplateEntry {
    private final TemplateEntry[] entries;

    public static TemplateEntry fromArray(TemplateEntry ... templateEntryArray) {
        if (templateEntryArray.length == 0) {
            return new StaticText("");
        }
        if (templateEntryArray.length == 1) {
            return templateEntryArray[0];
        }
        return new CompoundTemplateEntry(templateEntryArray);
    }

    private CompoundTemplateEntry(TemplateEntry[] templateEntryArray) {
        this.entries = templateEntryArray;
    }

    public void appendText(StringBuilder stringBuilder, TemplateEngineDataProvider templateEngineDataProvider) {
        for (TemplateEntry templateEntry : this.entries) {
            templateEntry.appendText(stringBuilder, templateEngineDataProvider);
        }
    }

    public boolean isValid(TemplateEngineDataProvider templateEngineDataProvider) {
        for (TemplateEntry templateEntry : this.entries) {
            if (templateEntry.isValid(templateEngineDataProvider)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TemplateEntry templateEntry : this.entries) {
            stringBuilder.append(templateEntry.toString());
        }
        return stringBuilder.toString();
    }
}

