/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.LanguageInfo;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String string) {
        this.baseurl = string;
    }

    public WikiReader() {
        this.baseurl = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
    }

    public String read(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "utf-8"));
        if (string.startsWith(this.baseurl) && !string.endsWith("?format=txt")) {
            return this.readFromTrac(bufferedReader);
        }
        return this.readNormal(bufferedReader);
    }

    public String readLang(String string) throws IOException {
        String string2 = LanguageInfo.getWikiLanguagePrefix();
        String string3 = this.readLang(new URL(this.baseurl + "/wiki/" + string2 + string));
        if (string3.isEmpty() && !string2.isEmpty()) {
            string3 = this.readLang(new URL(this.baseurl + "/wiki/" + string));
        }
        if (string3.isEmpty()) {
            throw new IOException(string + " does not exist");
        }
        return string3;
    }

    private String readLang(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        return this.readFromTrac(new BufferedReader(new InputStreamReader(inputStream, "utf-8")));
    }

    private String readNormal(BufferedReader bufferedReader) throws IOException {
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (!string2.contains("[[TranslatedPages]]")) {
                string = string + string2.replaceAll(" />", ">") + "\n";
            }
            string2 = bufferedReader.readLine();
        }
        return "<html>" + string + "</html>";
    }

    private String readFromTrac(BufferedReader bufferedReader) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            if (string2.contains("<div id=\"searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"wiki-toc trac-nav\"")) {
                bl2 = true;
            } else if (string2.contains("<div class=\"wikipage searchable\">")) {
                bl = true;
            } else if (string2.contains("<div class=\"buttons\">")) {
                bl = false;
            } else if (string2.contains("<h3>Attachments</h3>")) {
                bl = false;
            } else if (string2.contains("<div id=\"attachments\">")) {
                bl = false;
            } else if (string2.contains("<div class=\"trac-modifiedby\">")) {
                bl3 = true;
            }
            if (bl && !bl2 && !bl3) {
                string = string + string2.replaceAll("<img src=\"/", "<img border=\"0\" src=\"" + this.baseurl + "/").replaceAll("href=\"/", "href=\"" + this.baseurl + "/").replaceAll(" />", ">") + "\n";
            } else if (bl2 && string2.contains("</div>")) {
                bl2 = false;
            }
            if (string2.contains("</div>")) {
                bl3 = false;
            }
            string2 = bufferedReader.readLine();
        }
        if (string.indexOf("      Describe ") >= 0 || string.indexOf(" does not exist. You can create it here.</p>") >= 0) {
            return "";
        }
        return "<html>" + string + "</html>";
    }
}

