/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class AddWayHandler
extends RequestHandler {
    public static final String command = "add_way";

    public String[] getMandatoryParams() {
        return new String[]{"way"};
    }

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        Way way = new Way();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (String string : ((String)this.args.get("way")).split(";\\s*")) {
            String[] stringArray = string.split(",\\s*", 2);
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            Node node = new Node(new LatLon(d, d2));
            way.addNode(node);
            linkedList.add(new AddCommand(node));
        }
        linkedList.add(new AddCommand(way));
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Add way", new Object[0]), linkedList));
        Main.main.getCurrentDataSet().setSelected(way);
        if (PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            AutoScaleAction.autoScale("selection");
        } else {
            Main.map.mapView.repaint();
        }
    }

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new way.", new Object[0]);
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.CREATE_OBJECTS;
    }
}

