/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.io.auth.JosmPreferencesCredentialAgent;
import org.openstreetmap.josm.tools.Utils;

public class CredentialsManager
implements CredentialsAgent {
    private static CredentialsManager instance;
    private static CredentialsAgentFactory agentFactory;
    private CredentialsAgent delegate;

    public static CredentialsManager getInstance() {
        if (instance == null) {
            CredentialsAgent credentialsAgent = agentFactory == null ? new JosmPreferencesCredentialAgent() : agentFactory.getCredentialsAgent();
            instance = new CredentialsManager(credentialsAgent);
        }
        return instance;
    }

    public static void registerCredentialsAgentFactory(CredentialsAgentFactory credentialsAgentFactory) {
        agentFactory = credentialsAgentFactory;
        instance = null;
    }

    public CredentialsManager(CredentialsAgent credentialsAgent) {
        this.delegate = credentialsAgent;
    }

    public String getUsername() {
        return this.getUsername(OsmApi.getOsmApi().getHost());
    }

    public String getUsername(String string) {
        String string2 = null;
        try {
            PasswordAuthentication passwordAuthentication = this.lookup(Authenticator.RequestorType.SERVER, string);
            if (passwordAuthentication != null) {
                string2 = passwordAuthentication.getUserName();
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        return Utils.equal(string2 = string2.trim(), "") ? null : string2;
    }

    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String string) throws CredentialsAgentException {
        return this.delegate.lookup(requestorType, string);
    }

    public void store(Authenticator.RequestorType requestorType, String string, PasswordAuthentication passwordAuthentication) throws CredentialsAgentException {
        String string2;
        if (requestorType == Authenticator.RequestorType.SERVER && Utils.equal(OsmApi.getOsmApi().getHost(), string) && (string2 = passwordAuthentication.getUserName()) != null && !string2.trim().isEmpty()) {
            JosmUserIdentityManager.getInstance().setPartiallyIdentified(string2);
        }
        this.delegate.store(requestorType, string, passwordAuthentication);
    }

    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String string, boolean bl) throws CredentialsAgentException {
        return this.delegate.getCredentials(requestorType, string, bl);
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        return this.delegate.lookupOAuthAccessToken();
    }

    public void storeOAuthAccessToken(OAuthToken oAuthToken) throws CredentialsAgentException {
        this.delegate.storeOAuthAccessToken(oAuthToken);
    }

    public Component getPreferencesDecorationPanel() {
        return this.delegate.getPreferencesDecorationPanel();
    }

    public static interface CredentialsAgentFactory {
        public CredentialsAgent getCredentialsAgent();
    }
}

