/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM_France_DOM_ProjectionChoice
extends ListProjectionChoice
implements Alias {
    private static final String FortMarigotName = I18n.tr("Guadeloupe Fort-Marigot 1949", new Object[0]);
    private static final String SainteAnneName = I18n.tr("Guadeloupe Ste-Anne 1948", new Object[0]);
    private static final String MartiniqueName = I18n.tr("Martinique Fort Desaix 1952", new Object[0]);
    private static final String Reunion92Name = I18n.tr("Reunion RGR92", new Object[0]);
    private static final String Guyane92Name = I18n.tr("Guyane RGFG95", new Object[0]);
    private static final String[] utmGeodesicsNames = new String[]{FortMarigotName, SainteAnneName, MartiniqueName, Reunion92Name, Guyane92Name};

    public UTM_France_DOM_ProjectionChoice() {
        super("core:utmfrancedom", I18n.tr("UTM France (DOM)", new Object[0]), utmGeodesicsNames, I18n.tr("UTM Geodesic system", new Object[0]));
    }

    @Override
    protected String indexToZone(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    protected int zoneToIndex(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultIndex;
        }
    }

    @Override
    public Projection getProjection() {
        return new UTM_France_DOM(this.index);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[UTM_France_DOM.utmEPSGs.length];
        for (int i = 0; i < UTM_France_DOM.utmEPSGs.length; ++i) {
            stringArray[i] = "EPSG:" + UTM_France_DOM.utmEPSGs[i];
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (int i = 0; i < UTM_France_DOM.utmEPSGs.length; ++i) {
            if (!("EPSG:" + UTM_France_DOM.utmEPSGs[i]).equals(string)) continue;
            return Collections.singleton(Integer.toString(i + 1));
        }
        return null;
    }

    @Override
    public String getAlias() {
        return UTM_France_DOM.class.getName();
    }
}

