/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final double EPSILION = 1.0E-11;

    public static <T> boolean exists(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean exists(Iterable<T> iterable, Class<? extends T> clazz) {
        for (T t : iterable) {
            if (!clazz.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> T find(Iterable<? super T> iterable, Class<? extends T> clazz) {
        for (T t : iterable) {
            if (!clazz.isInstance(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> Collection<T> filter(Collection<? extends T> collection, Predicate<? super T> predicate) {
        return new FilteredCollection<T>(collection, predicate);
    }

    public static <T> T firstNonNull(T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <S, T extends S> SubclassFilteredCollection<S, T> filteredCollection(Collection<S> collection, final Class<T> clazz) {
        return new SubclassFilteredCollection(collection, new Predicate<S>(){

            @Override
            public boolean evaluate(S s) {
                return clazz.isInstance(s);
            }
        });
    }

    public static <T> int indexOf(Iterable<? extends T> iterable, Predicate<? super T> predicate) {
        int n = 0;
        for (T t : iterable) {
            if (predicate.evaluate(t)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int min(int n, int n2, int n3) {
        if (n2 < n3) {
            if (n < n2) {
                return n;
            }
            return n2;
        }
        if (n < n3) {
            return n;
        }
        return n3;
    }

    public static int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    public static <T> boolean equal(T t, T t2) {
        if (t == t2) {
            return true;
        }
        return t != null && t.equals(t2);
    }

    public static void ensure(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new AssertionError((Object)MessageFormat.format(string, objectArray));
        }
    }

    public static int mod(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        int n3 = n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        return n3;
    }

    public static String join(String string, Collection<?> collection) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = null;
        for (Object object : collection) {
            if (object == null) {
                object = "";
            }
            if (stringBuilder != null) {
                stringBuilder.append(string).append(object.toString());
                continue;
            }
            stringBuilder = new StringBuilder(object.toString());
        }
        return stringBuilder.toString();
    }

    public static String joinAsHtmlUnorderedList(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("<ul>");
        for (Object obj : collection) {
            stringBuilder.append("<li>").append(obj).append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    public static String toString(Color color) {
        if (color == null) {
            return "null";
        }
        if (color.getAlpha() == 255) {
            return String.format("#%06x", color.getRGB() & 0xFFFFFF);
        }
        return String.format("#%06x(alpha=%d)", color.getRGB() & 0xFFFFFF, color.getAlpha());
    }

    public static Integer color_float2int(Float f) {
        if (f == null) {
            return null;
        }
        if (f.floatValue() < 0.0f || f.floatValue() > 1.0f) {
            return 255;
        }
        return (int)(255.0f * f.floatValue() + 0.5f);
    }

    public static Float color_int2float(Integer n) {
        if (n == null) {
            return null;
        }
        if (n < 0 || n > 255) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf((float)n.intValue() / 255.0f);
    }

    public static Color complement(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static int copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        int n2 = 0;
        byte[] byArray = new byte[512];
        while ((n = inputStream.read(byArray)) != -1) {
            n2 += n;
            outputStream.write(byArray, 0, n);
        }
        return n2;
    }

    public static boolean deleteDirectory(File file) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    Utils.deleteDirectory(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        return file.delete();
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean equalsEpsilon(double d, double d2) {
        return Math.abs(d - d2) <= 1.0E-11;
    }

    public static boolean copyToClipboard(String string) {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return false;
        }
    }

    public static String getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = null;
        for (int i = 0; transferable == null && i < 10; ++i) {
            try {
                transferable = clipboard.getContents(null);
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return null;
    }

    public static String md5Hex(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException();
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException();
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return Utils.toHexString(byArray2);
    }

    public static String toHexString(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray2[i * 2] = cArray[n / 16];
            cArray2[i * 2 + 1] = cArray[n % 16];
        }
        return new String(cArray2);
    }

    public static <T> List<T> topologicalSort(MultiMap<T, T> multiMap) {
        Object object2;
        MultiMap multiMap2 = new MultiMap();
        for (Object object2 : multiMap.keySet()) {
            multiMap2.putVoid(object2);
            for (Object b : multiMap.get(object2)) {
                multiMap2.putVoid(b);
                multiMap2.put(object2, b);
            }
        }
        int n = multiMap2.size();
        object2 = new ArrayList();
        for (int i = 0; i < n; ++i) {
            Object b;
            b = null;
            for (Object a : multiMap2.keySet()) {
                if (multiMap2.get(a).size() != 0) continue;
                b = a;
                break;
            }
            if (b == null) {
                throw new RuntimeException();
            }
            object2.add(b);
            multiMap2.remove(b);
            for (Object a : multiMap2.keySet()) {
                multiMap2.remove(a, b);
            }
        }
        if (object2.size() != n) {
            throw new RuntimeException();
        }
        return object2;
    }

    public static <A, B> Collection<B> transform(final Collection<? extends A> collection, final Function<A, B> function) {
        return new Collection<B>(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            public boolean isEmpty() {
                return collection.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return collection.contains(object);
            }

            @Override
            public Object[] toArray() {
                return collection.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return collection.toArray(TArray);
            }

            public String toString() {
                return collection.toString();
            }

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private Iterator<? extends A> it;
                    {
                        this.it = collection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public B next() {
                        return function.apply(this.it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public boolean add(B b) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> collection2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends B> collection2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> collection2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> collection2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<A, B> {
        public B apply(A var1);
    }
}

