/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OsmServerUserInfoReader
extends OsmServerReader {
    protected static String getAttribute(Node node, String string) {
        return node.getAttributes().getNamedItem(string).getNodeValue();
    }

    public static UserInfo buildFromXML(Document document) throws OsmDataParsingException {
        try {
            NodeList nodeList;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            UserInfo userInfo = new UserInfo();
            Node node = (Node)xPath.compile("/osm/user[1]").evaluate(document, XPathConstants.NODE);
            if (node == null) {
                throw new OsmDataParsingException(I18n.tr("XML tag <user> is missing.", new Object[0]));
            }
            String string = OsmServerUserInfoReader.getAttribute(node, "id");
            if (string == null) {
                throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "id", "user"));
            }
            try {
                userInfo.setId(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "id", "user", string));
            }
            string = OsmServerUserInfoReader.getAttribute(node, "display_name");
            userInfo.setDisplayName(string);
            string = OsmServerUserInfoReader.getAttribute(node, "account_created");
            if (string != null) {
                userInfo.setAccountCreated(DateUtils.fromString(string));
            }
            if ((node = (Node)xPath.compile("/osm/user[1]/description[1]/text()").evaluate(document, XPathConstants.NODE)) != null) {
                userInfo.setDescription(node.getNodeValue());
            }
            if ((node = (Node)xPath.compile("/osm/user[1]/home").evaluate(document, XPathConstants.NODE)) != null) {
                int n;
                double d;
                double d2;
                string = OsmServerUserInfoReader.getAttribute(node, "lat");
                if (string == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lat", "home"));
                }
                try {
                    d2 = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lat", "home", string));
                }
                string = OsmServerUserInfoReader.getAttribute(node, "lon");
                if (string == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "lon", "home"));
                }
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "lon", "home", string));
                }
                string = OsmServerUserInfoReader.getAttribute(node, "zoom");
                if (string == null) {
                    throw new OsmDataParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "zoom", "home"));
                }
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new OsmDataParsingException(I18n.tr("Illegal value for attribute ''{0}'' on XML tag ''{1}''. Got {2}.", "zoom", "home", string));
                }
                userInfo.setHome(new LatLon(d2, d));
                userInfo.setHomeZoom(n);
            }
            if ((nodeList = (NodeList)xPath.compile("/osm/user[1]/languages[1]/lang").evaluate(document, XPathConstants.NODESET)) != null) {
                LinkedList<String> linkedList = new LinkedList<String>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    linkedList.add(nodeList.item(i).getNodeValue());
                }
                userInfo.setLanguages(linkedList);
            }
            return userInfo;
        }
        catch (XPathException xPathException) {
            throw new OsmDataParsingException(xPathException);
        }
    }

    public OsmServerUserInfoReader() {
        this.setDoAuthenticate(true);
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public UserInfo fetchUserInfo(ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Reading user info ...", new Object[0]));
            InputStream inputStream = this.getInputStream("user/details", progressMonitor.createSubTaskMonitor(1, true));
            UserInfo userInfo = OsmServerUserInfoReader.buildFromXML(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream));
            return userInfo;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

