/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class ButtonMarker
extends Marker {
    private Rectangle buttonRectangle;

    public ButtonMarker(LatLon latLon, String string, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, "", string, markerLayer, d, d2);
        this.buttonRectangle = new Rectangle(0, 0, this.symbol.getIconWidth(), this.symbol.getIconHeight());
    }

    public ButtonMarker(LatLon latLon, TemplateEngineDataProvider templateEngineDataProvider, String string, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, templateEngineDataProvider, string, markerLayer, d, d2);
        this.buttonRectangle = new Rectangle(0, 0, this.symbol.getIconWidth(), this.symbol.getIconHeight());
    }

    public boolean containsPoint(Point point) {
        Point point2 = Main.map.mapView.getPoint(this.getEastNorth());
        this.buttonRectangle.setLocation(point2.x + 4, point2.y + 2);
        return this.buttonRectangle.contains(point);
    }

    public void paint(Graphics graphics, MapView mapView, boolean bl, boolean bl2) {
        if (!bl2) {
            super.paint(graphics, mapView, bl, bl2);
            return;
        }
        Point point = mapView.getPoint(this.getEastNorth());
        this.buttonRectangle.setLocation(point.x + 4, point.y + 2);
        this.symbol.paintIcon(mapView, graphics, point.x + 4, point.y + 2);
        Point point2 = mapView.getMousePosition();
        Border border = point2 != null && bl && this.containsPoint(point2) ? BorderFactory.createBevelBorder(1) : BorderFactory.createBevelBorder(0);
        Insets insets = border.getBorderInsets(mapView);
        Rectangle rectangle = new Rectangle(this.buttonRectangle);
        rectangle.grow((insets.top + insets.bottom) / 2, (insets.left + insets.right) / 2);
        border.paintBorder(mapView, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        String string = this.getText();
        if (string != null && bl2 && Main.pref.getBoolean("marker.buttonlabels", true)) {
            graphics.drawString(string, point.x + 4, point.y + 2);
        }
    }
}

