/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.gui.io.ActionFlagsTableCell;
import org.openstreetmap.josm.gui.io.LayerNameAndFilePathTableCell;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class SaveLayersTableColumnModel
extends DefaultTableColumnModel {
    protected void build() {
        TableColumn tableColumn = null;
        LayerNameAndFilePathTableCell layerNameAndFilePathTableCell = new LayerNameAndFilePathTableCell();
        tableColumn = new TableColumn(0);
        tableColumn.setHeaderValue(I18n.tr("Layer Name and File Path", new Object[0]));
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(layerNameAndFilePathTableCell);
        tableColumn.setCellEditor(layerNameAndFilePathTableCell);
        tableColumn.setPreferredWidth(324);
        this.addColumn(tableColumn);
        tableColumn = new TableColumn(1);
        tableColumn.setHeaderValue(I18n.tr("Recommended Actions", new Object[0]));
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(new RecommendedActionsTableCell());
        tableColumn.setPreferredWidth(150);
        this.addColumn(tableColumn);
        ActionFlagsTableCell actionFlagsTableCell = new ActionFlagsTableCell();
        tableColumn = new TableColumn(2);
        tableColumn.setHeaderValue(I18n.tr("Actions To Take", new Object[0]));
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(actionFlagsTableCell);
        tableColumn.setCellEditor(actionFlagsTableCell);
        tableColumn.setPreferredWidth(100);
        this.addColumn(tableColumn);
    }

    public SaveLayersTableColumnModel() {
        this.build();
    }

    private static class RecommendedActionsTableCell
    extends JPanel
    implements TableCellRenderer {
        private static final JPanel pnlEmpty = new JPanel();
        private static final JLabel needsUpload = new JLabel(I18n.tr("should be uploaded", new Object[0]));
        private static final JLabel needsSave = new JLabel(I18n.tr("should be saved", new Object[0]));
        private static final GBC defaultCellStyle = GBC.eol().fill(2).insets(2, 0, 2, 0);

        public RecommendedActionsTableCell() {
            this.setLayout(new GridBagLayout());
            pnlEmpty.setPreferredSize(new Dimension(1, 19));
            needsUpload.setPreferredSize(new Dimension(RecommendedActionsTableCell.needsUpload.getPreferredSize().width, 19));
            needsSave.setPreferredSize(new Dimension(RecommendedActionsTableCell.needsSave.getPreferredSize().width, 19));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            SaveLayerInfo saveLayerInfo = (SaveLayerInfo)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (saveLayerInfo.getLayer().requiresUploadToServer() && !saveLayerInfo.getLayer().isUploadDiscouraged()) {
                this.add((Component)needsUpload, defaultCellStyle);
                stringBuilder.append(I18n.tr("Layer ''{0}'' has modifications which should be uploaded to the server.", saveLayerInfo.getName()));
            } else {
                this.add((Component)pnlEmpty, defaultCellStyle);
                if (saveLayerInfo.getLayer().requiresUploadToServer()) {
                    stringBuilder.append(I18n.tr("Layer ''{0}'' has modifications which are discouraged to be uploaded.", saveLayerInfo.getName()));
                } else {
                    stringBuilder.append(I18n.tr("Layer ''{0}'' has no modifications to be uploaded.", saveLayerInfo.getName()));
                }
            }
            stringBuilder.append("<br/>");
            if (saveLayerInfo.getLayer().requiresSaveToFile()) {
                this.add((Component)needsSave, defaultCellStyle);
                stringBuilder.append(I18n.tr("Layer ''{0}'' has modifications which should be saved to its associated file ''{1}''.", saveLayerInfo.getName(), saveLayerInfo.getFile().toString()));
            } else {
                this.add((Component)pnlEmpty, defaultCellStyle);
                stringBuilder.append(I18n.tr("Layer ''{0}'' has no modifications to be saved.", saveLayerInfo.getName()));
            }
            stringBuilder.append("</html>");
            this.setToolTipText(stringBuilder.toString());
            return this;
        }
    }
}

