/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Utils;

public class BoundingBoxSelection
implements DownloadSelection {
    private JTextField[] latlon = null;
    private final JTextArea tfOsmUrl = new JTextArea();
    private final JTextArea showUrl = new JTextArea();
    private DownloadDialog parent;
    private Border errorBorder = BorderFactory.createLineBorder(Color.RED, 1);

    protected void registerBoundingBoxBuilder() {
        BoundingBoxBuilder boundingBoxBuilder = new BoundingBoxBuilder();
        for (int i = 0; i < this.latlon.length; ++i) {
            this.latlon[i].addFocusListener(boundingBoxBuilder);
            this.latlon[i].addActionListener(boundingBoxBuilder);
        }
    }

    protected void buildDownloadAreaInputFields() {
        this.latlon = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.latlon[i] = new JTextField(11);
            this.latlon[i].setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            this.latlon[i].addFocusListener(new SelectAllOnFocusHandler(this.latlon[i]));
        }
        LatValueChecker latValueChecker = new LatValueChecker(this.latlon[0]);
        this.latlon[0].addFocusListener(latValueChecker);
        this.latlon[0].addActionListener(latValueChecker);
        latValueChecker = new LatValueChecker(this.latlon[2]);
        this.latlon[2].addFocusListener(latValueChecker);
        this.latlon[2].addActionListener(latValueChecker);
        LonValueChecker lonValueChecker = new LonValueChecker(this.latlon[1]);
        this.latlon[1].addFocusListener(lonValueChecker);
        this.latlon[1].addActionListener(lonValueChecker);
        lonValueChecker = new LonValueChecker(this.latlon[3]);
        this.latlon[3].addFocusListener(lonValueChecker);
        this.latlon[3].addActionListener(lonValueChecker);
        this.registerBoundingBoxBuilder();
    }

    public void addGui(DownloadDialog downloadDialog) {
        this.buildDownloadAreaInputFields();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusHandler(this.tfOsmUrl));
        this.tfOsmUrl.setLineWrap(true);
        this.tfOsmUrl.setBorder(this.latlon[0].getBorder());
        jPanel.add((Component)new JLabel(I18n.tr("min lat", new Object[0])), GBC.std().insets(10, 20, 5, 0));
        jPanel.add((Component)this.latlon[0], GBC.std().insets(0, 20, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("min lon", new Object[0])), GBC.std().insets(10, 20, 5, 0));
        jPanel.add((Component)this.latlon[1], GBC.eol().insets(0, 20, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("max lat", new Object[0])), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.latlon[2], GBC.std());
        jPanel.add((Component)new JLabel(I18n.tr("max lon", new Object[0])), GBC.std().insets(10, 0, 5, 0));
        jPanel.add((Component)this.latlon[3], GBC.eol());
        JButton jButton = new JButton(I18n.tr("Clear textarea", new Object[0]));
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BoundingBoxSelection.this.tfOsmUrl.setText("");
            }
        });
        jPanel.add((Component)jButton, GBC.eol().insets(10, 20, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("URL from www.openstreetmap.org (you can paste an URL here to download the area)", new Object[0])), GBC.eol().insets(10, 5, 5, 0));
        jPanel.add((Component)this.tfOsmUrl, GBC.eop().insets(10, 0, 5, 0).fill());
        this.tfOsmUrl.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            private void checkPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    OsmUrlPopup osmUrlPopup = new OsmUrlPopup();
                    osmUrlPopup.show(BoundingBoxSelection.this.tfOsmUrl, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        jPanel.add((Component)this.showUrl, GBC.eop().insets(10, 0, 5, 5));
        this.showUrl.setEditable(false);
        this.showUrl.setBackground(jPanel.getBackground());
        this.showUrl.addFocusListener(new SelectAllOnFocusHandler(this.showUrl));
        downloadDialog.addDownloadAreaSelector(jPanel, I18n.tr("Bounding Box", new Object[0]));
        this.parent = downloadDialog;
    }

    public void setDownloadArea(Bounds bounds) {
        this.updateBboxFields(bounds);
        this.updateUrl(bounds);
    }

    public Bounds getDownloadArea() {
        double[] dArray = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                dArray[i] = Double.parseDouble(this.latlon[i].getText());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (!LatLon.isValidLat(dArray[0]) || !LatLon.isValidLon(dArray[1])) {
            return null;
        }
        if (!LatLon.isValidLat(dArray[2]) || !LatLon.isValidLon(dArray[3])) {
            return null;
        }
        return new Bounds(dArray);
    }

    private boolean parseURL(DownloadDialog downloadDialog) {
        Bounds bounds = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (bounds == null) {
            return false;
        }
        downloadDialog.boundingBoxChanged(bounds, this);
        this.updateBboxFields(bounds);
        this.updateUrl(bounds);
        return true;
    }

    private void updateBboxFields(Bounds bounds) {
        if (bounds == null) {
            return;
        }
        this.latlon[0].setText(bounds.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.latlon[1].setText(bounds.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.latlon[2].setText(bounds.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.latlon[3].setText(bounds.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES));
        for (JTextField jTextField : this.latlon) {
            this.resetErrorMessage(jTextField);
        }
    }

    private void updateUrl(Bounds bounds) {
        if (bounds == null) {
            return;
        }
        this.showUrl.setText(OsmUrlToBounds.getURL(bounds));
    }

    protected void setErrorMessage(JTextField jTextField, String string) {
        jTextField.setBorder(this.errorBorder);
        jTextField.setToolTipText(string);
    }

    protected void resetErrorMessage(JTextField jTextField) {
        jTextField.setBorder(UIManager.getBorder("TextField.border"));
        jTextField.setToolTipText("");
    }

    class BoundingBoxBuilder
    extends FocusAdapter
    implements ActionListener {
        BoundingBoxBuilder() {
        }

        protected Bounds build() {
            double d;
            double d2;
            double d3;
            double d4;
            try {
                d4 = Double.parseDouble(BoundingBoxSelection.this.latlon[0].getText().trim());
                d3 = Double.parseDouble(BoundingBoxSelection.this.latlon[1].getText().trim());
                d2 = Double.parseDouble(BoundingBoxSelection.this.latlon[2].getText().trim());
                d = Double.parseDouble(BoundingBoxSelection.this.latlon[3].getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (!(LatLon.isValidLon(d3) && LatLon.isValidLon(d) && LatLon.isValidLat(d4) && LatLon.isValidLat(d2))) {
                return null;
            }
            if (d3 > d) {
                return null;
            }
            if (d4 > d2) {
                return null;
            }
            return new Bounds(d4, d3, d2, d);
        }

        protected void refreshBounds() {
            Bounds bounds = this.build();
            BoundingBoxSelection.this.parent.boundingBoxChanged(bounds, BoundingBoxSelection.this);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.refreshBounds();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.refreshBounds();
        }
    }

    class OsmUrlPopup
    extends JPopupMenu {
        public OsmUrlPopup() {
            this.add(new PasteUrlAction());
        }
    }

    class PasteUrlAction
    extends AbstractAction
    implements FlavorListener {
        public PasteUrlAction() {
            this.putValue("Name", I18n.tr("Paste", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("paste"));
            this.putValue("ShortDescription", I18n.tr("Paste URL from clipboard", new Object[0]));
            Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Utils.getClipboardContent();
            if (string != null) {
                BoundingBoxSelection.this.tfOsmUrl.setText(string);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(Utils.getClipboardContent() != null);
        }

        public void flavorsChanged(FlavorEvent flavorEvent) {
            this.updateEnabledState();
        }
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelection.this.parseURL(BoundingBoxSelection.this.parent);
        }
    }

    static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private JTextComponent tfTarget;

        public SelectAllOnFocusHandler(JTextComponent jTextComponent) {
            this.tfTarget = jTextComponent;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.tfTarget.selectAll();
        }
    }

    class LonValueChecker
    extends FocusAdapter
    implements ActionListener {
        private JTextField tfLonValue;

        public LonValueChecker(JTextField jTextField) {
            this.tfLonValue = jTextField;
        }

        protected void check() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.tfLonValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLonValue.getText()));
                return;
            }
            if (!LatLon.isValidLon(d)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLonValue, I18n.tr("Value for longitude in range [-180,180] required.", this.tfLonValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLonValue);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.check();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.check();
        }
    }

    class LatValueChecker
    extends FocusAdapter
    implements ActionListener {
        private JTextField tfLatValue;

        public LatValueChecker(JTextField jTextField) {
            this.tfLatValue = jTextField;
        }

        protected void check() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.tfLatValue.getText());
            }
            catch (NumberFormatException numberFormatException) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("The string ''{0}'' is not a valid double value.", this.tfLatValue.getText()));
                return;
            }
            if (!LatLon.isValidLat(d)) {
                BoundingBoxSelection.this.setErrorMessage(this.tfLatValue, I18n.tr("Value for latitude in range [-90,90] required.", this.tfLatValue.getText()));
                return;
            }
            BoundingBoxSelection.this.resetErrorMessage(this.tfLatValue);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.check();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.check();
        }
    }
}

