/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class Lambert93
extends AbstractProjection {
    public Lambert93() {
        this.ellps = Ellipsoid.GRS80;
        this.datum = GRS80Datum.INSTANCE;
        this.x_0 = 700000.0;
        this.y_0 = 6600000.0;
        this.lon_0 = 3.0;
        this.proj = new LambertConformalConic();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = Lambert93.this.ellps;
                    this.lat_0 = 46.5;
                    this.lat_1 = 44.0;
                    this.lat_2 = 49.0;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    public String getCacheDirectoryName() {
        return "lambert93";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(41.0, -5.5), new LatLon(51.0, 10.2), false);
    }

    public Integer getEpsgCode() {
        return 2154;
    }

    public String toString() {
        return I18n.tr("Lambert 93 (France)", new Object[0]);
    }
}

