/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.A;
import com.kitfox.svg.Circle;
import com.kitfox.svg.ClipPath;
import com.kitfox.svg.Defs;
import com.kitfox.svg.Desc;
import com.kitfox.svg.Ellipse;
import com.kitfox.svg.Filter;
import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.Glyph;
import com.kitfox.svg.Group;
import com.kitfox.svg.Hkern;
import com.kitfox.svg.ImageSVG;
import com.kitfox.svg.Line;
import com.kitfox.svg.LinearGradient;
import com.kitfox.svg.Marker;
import com.kitfox.svg.Metadata;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.Path;
import com.kitfox.svg.PatternSVG;
import com.kitfox.svg.Polygon;
import com.kitfox.svg.Polyline;
import com.kitfox.svg.RadialGradient;
import com.kitfox.svg.Rect;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.Stop;
import com.kitfox.svg.Style;
import com.kitfox.svg.Symbol;
import com.kitfox.svg.Text;
import com.kitfox.svg.Title;
import com.kitfox.svg.Tspan;
import com.kitfox.svg.Use;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGLoader
extends DefaultHandler {
    final HashMap nodeClasses = new HashMap();
    final LinkedList buildStack = new LinkedList();
    final HashSet ignoreClasses = new HashSet();
    final SVGLoaderHelper helper;
    final SVGDiagram diagram;
    int skipNonSVGTagDepth = 0;
    int indent = 0;
    final boolean verbose;

    public SVGLoader(URI uRI, SVGUniverse sVGUniverse) {
        this(uRI, sVGUniverse, false);
    }

    public SVGLoader(URI uRI, SVGUniverse sVGUniverse, boolean bl) {
        this.verbose = bl;
        this.diagram = new SVGDiagram(uRI, sVGUniverse);
        this.nodeClasses.put("a", A.class);
        this.nodeClasses.put("circle", Circle.class);
        this.nodeClasses.put("clippath", ClipPath.class);
        this.nodeClasses.put("defs", Defs.class);
        this.nodeClasses.put("desc", Desc.class);
        this.nodeClasses.put("ellipse", Ellipse.class);
        this.nodeClasses.put("filter", Filter.class);
        this.nodeClasses.put("font", Font.class);
        this.nodeClasses.put("font-face", FontFace.class);
        this.nodeClasses.put("g", Group.class);
        this.nodeClasses.put("glyph", Glyph.class);
        this.nodeClasses.put("hkern", Hkern.class);
        this.nodeClasses.put("image", ImageSVG.class);
        this.nodeClasses.put("line", Line.class);
        this.nodeClasses.put("lineargradient", LinearGradient.class);
        this.nodeClasses.put("marker", Marker.class);
        this.nodeClasses.put("metadata", Metadata.class);
        this.nodeClasses.put("missing-glyph", MissingGlyph.class);
        this.nodeClasses.put("path", Path.class);
        this.nodeClasses.put("pattern", PatternSVG.class);
        this.nodeClasses.put("polygon", Polygon.class);
        this.nodeClasses.put("polyline", Polyline.class);
        this.nodeClasses.put("radialgradient", RadialGradient.class);
        this.nodeClasses.put("rect", Rect.class);
        this.nodeClasses.put("shape", ShapeElement.class);
        this.nodeClasses.put("stop", Stop.class);
        this.nodeClasses.put("style", Style.class);
        this.nodeClasses.put("svg", SVGRoot.class);
        this.nodeClasses.put("symbol", Symbol.class);
        this.nodeClasses.put("text", Text.class);
        this.nodeClasses.put("title", Title.class);
        this.nodeClasses.put("tspan", Tspan.class);
        this.nodeClasses.put("use", Use.class);
        this.ignoreClasses.add("midpointstop");
        this.helper = new SVGLoaderHelper(uRI, sVGUniverse, this.diagram);
    }

    private String printIndent(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.verbose) {
            System.err.println(this.printIndent(this.indent, " ") + "Starting parse of tag " + string2 + ": " + string);
        }
        ++this.indent;
        if (this.skipNonSVGTagDepth != 0 || !string.equals("") && !string.equals("http://www.w3.org/2000/svg")) {
            ++this.skipNonSVGTagDepth;
            return;
        }
        Object v = this.nodeClasses.get(string2 = string2.toLowerCase());
        if (v == null) {
            if (!this.ignoreClasses.contains(string2) && this.verbose) {
                System.err.println("SVGLoader: Could not identify tag '" + string2 + "'");
            }
            return;
        }
        try {
            Class clazz = (Class)v;
            SVGElement sVGElement = (SVGElement)clazz.newInstance();
            SVGElement sVGElement2 = null;
            if (this.buildStack.size() != 0) {
                sVGElement2 = (SVGElement)this.buildStack.getLast();
            }
            sVGElement.loaderStartElement(this.helper, attributes, sVGElement2);
            this.buildStack.addLast(sVGElement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.indent;
        if (this.verbose) {
            System.err.println(this.printIndent(this.indent, " ") + "Ending parse of tag " + string2 + ": " + string);
        }
        if (this.skipNonSVGTagDepth != 0) {
            --this.skipNonSVGTagDepth;
            return;
        }
        Object v = this.nodeClasses.get(string2 = string2.toLowerCase());
        if (v == null) {
            return;
        }
        try {
            SVGElement sVGElement = (SVGElement)this.buildStack.removeLast();
            sVGElement.loaderEndElement(this.helper);
            SVGElement sVGElement2 = null;
            if (this.buildStack.size() != 0) {
                sVGElement2 = (SVGElement)this.buildStack.getLast();
            }
            if (sVGElement2 != null) {
                sVGElement2.loaderAddChild(this.helper, sVGElement);
            } else {
                this.diagram.setRoot((SVGRoot)sVGElement);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skipNonSVGTagDepth != 0) {
            return;
        }
        if (this.buildStack.size() != 0) {
            SVGElement sVGElement = (SVGElement)this.buildStack.getLast();
            String string = new String(cArray, n, n2);
            sVGElement.loaderAddText(this.helper, string);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public SVGDiagram getLoadedDiagram() {
        return this.diagram;
    }
}

