/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;

public class PlatformHookOsx
extends PlatformHookUnixoid
implements PlatformHook,
InvocationHandler {
    private static PlatformHookOsx ivhandler = new PlatformHookOsx();

    public void preStartupHook() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    public void startupHook() {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Object obj = clazz.getConstructor(null).newInstance(null);
            Class<?> clazz2 = Class.forName("com.apple.eawt.ApplicationListener");
            Method method = clazz.getDeclaredMethod("addApplicationListener", clazz2);
            Object object = Proxy.newProxyInstance(PlatformHookOsx.class.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)ivhandler);
            method.invoke(obj, object);
            Method method2 = clazz.getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            method2.invoke(obj, Boolean.TRUE);
        }
        catch (Exception exception) {
            System.out.println("Failed to register with OSX: " + exception);
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Boolean bl = Boolean.TRUE;
        if (method.getName().equals("handleQuit")) {
            bl = Main.exitJosm(false);
        } else if (method.getName().equals("handleAbout")) {
            Main.main.menu.about.actionPerformed(null);
        } else if (method.getName().equals("handlePreferences")) {
            Main.main.menu.preferences.actionPerformed(null);
        } else {
            return null;
        }
        if (objectArray[0] != null) {
            try {
                objectArray[0].getClass().getDeclaredMethod("setHandled", Boolean.TYPE).invoke(objectArray[0], bl);
            }
            catch (Exception exception) {
                System.out.println("Failed to report handled event: " + exception);
            }
        }
        return null;
    }

    public void openUrl(String string) throws IOException {
        Runtime.getRuntime().exec("open " + string);
    }

    public void initSystemShortcuts() {
        Shortcut.registerSystemShortcut("apple-reserved-01", I18n.tr("reserved", new Object[0]), 32, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-02", I18n.tr("reserved", new Object[0]), 32, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-03", I18n.tr("reserved", new Object[0]), 32, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-04", I18n.tr("reserved", new Object[0]), 32, 384).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-05", I18n.tr("reserved", new Object[0]), 9, 64).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-06", I18n.tr("reserved", new Object[0]), 9, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-07", I18n.tr("reserved", new Object[0]), 9, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-08", I18n.tr("reserved", new Object[0]), 9, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-09", I18n.tr("reserved", new Object[0]), 9, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-10", I18n.tr("reserved", new Object[0]), 27, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-11", I18n.tr("reserved", new Object[0]), 27, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-12", I18n.tr("reserved", new Object[0]), 112, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-13", I18n.tr("reserved", new Object[0]), 113, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-14", I18n.tr("reserved", new Object[0]), 114, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-15", I18n.tr("reserved", new Object[0]), 115, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-16", I18n.tr("reserved", new Object[0]), 115, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-17", I18n.tr("reserved", new Object[0]), 116, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-18", I18n.tr("reserved", new Object[0]), 116, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-19", I18n.tr("reserved", new Object[0]), 117, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-20", I18n.tr("reserved", new Object[0]), 117, 192).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-21", I18n.tr("reserved", new Object[0]), 118, 128).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-26", I18n.tr("reserved", new Object[0]), 128, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-27", I18n.tr("reserved", new Object[0]), 128, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-28", I18n.tr("reserved", new Object[0]), 128, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-29", I18n.tr("reserved", new Object[0]), 45, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-30", I18n.tr("reserved", new Object[0]), 45, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:align-left", I18n.tr("reserved", new Object[0]), 91, 256);
        Shortcut.registerSystemShortcut("system:align-right", I18n.tr("reserved", new Object[0]), 93, 256);
        Shortcut.registerSystemShortcut("system:spelling", I18n.tr("reserved", new Object[0]), 513, 256);
        Shortcut.registerSystemShortcut("system:spellcheck", I18n.tr("reserved", new Object[0]), 59, 256);
        Shortcut.registerSystemShortcut("system:preferences", I18n.tr("reserved", new Object[0]), 44, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-31", I18n.tr("reserved", new Object[0]), 44, 832).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-32", I18n.tr("reserved", new Object[0]), 46, 832).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-33", I18n.tr("reserved", new Object[0]), 47, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-34", I18n.tr("reserved", new Object[0]), 61, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-35", I18n.tr("reserved", new Object[0]), 61, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-36", I18n.tr("reserved", new Object[0]), 51, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-37", I18n.tr("reserved", new Object[0]), 51, 448).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-38", I18n.tr("reserved", new Object[0]), 52, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-39", I18n.tr("reserved", new Object[0]), 52, 448).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-40", I18n.tr("reserved", new Object[0]), 56, 768).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-41", I18n.tr("reserved", new Object[0]), 56, 896).setAutomatic();
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 256);
        Shortcut.registerSystemShortcut("system:bold", I18n.tr("reserved", new Object[0]), 66, 256);
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 256);
        Shortcut.registerSystemShortcut("system:colors", I18n.tr("reserved", new Object[0]), 67, 320);
        Shortcut.registerSystemShortcut("system:copystyle", I18n.tr("reserved", new Object[0]), 67, 768);
        Shortcut.registerSystemShortcut("system:copyformat", I18n.tr("reserved", new Object[0]), 67, 384).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-42", I18n.tr("reserved", new Object[0]), 68, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:dictionarylookup", I18n.tr("reserved", new Object[0]), 68, 384);
        Shortcut.registerSystemShortcut("system:findselected", I18n.tr("reserved", new Object[0]), 69, 256);
        Shortcut.registerSystemShortcut("system:find", I18n.tr("reserved", new Object[0]), 70, 256);
        Shortcut.registerSystemShortcut("system:search", I18n.tr("reserved", new Object[0]), 70, 768);
        Shortcut.registerSystemShortcut("system:findnext", I18n.tr("reserved", new Object[0]), 71, 256);
        Shortcut.registerSystemShortcut("system:findprev", I18n.tr("reserved", new Object[0]), 71, 320);
        Shortcut.registerSystemShortcut("system:hide", I18n.tr("reserved", new Object[0]), 72, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:hideothers", I18n.tr("reserved", new Object[0]), 72, 768).setAutomatic();
        Shortcut.registerSystemShortcut("system:info", I18n.tr("reserved", new Object[0]), 73, 256);
        Shortcut.registerSystemShortcut("system:inspector", I18n.tr("reserved", new Object[0]), 73, 768);
        Shortcut.registerSystemShortcut("system:toselection", I18n.tr("reserved", new Object[0]), 74, 256);
        Shortcut.registerSystemShortcut("system:minimize", I18n.tr("reserved", new Object[0]), 77, 256);
        Shortcut.registerSystemShortcut("system:minimizeall", I18n.tr("reserved", new Object[0]), 77, 768);
        Shortcut.registerSystemShortcut("system:new", I18n.tr("reserved", new Object[0]), 78, 256);
        Shortcut.registerSystemShortcut("system:open", I18n.tr("reserved", new Object[0]), 79, 256);
        Shortcut.registerSystemShortcut("system:print", I18n.tr("reserved", new Object[0]), 80, 256);
        Shortcut.registerSystemShortcut("system:printsetup", I18n.tr("reserved", new Object[0]), 80, 320);
        Shortcut.registerSystemShortcut("system:menuexit", I18n.tr("reserved", new Object[0]), 81, 256).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-43", I18n.tr("reserved", new Object[0]), 81, 320).setAutomatic();
        Shortcut.registerSystemShortcut("apple-reserved-44", I18n.tr("reserved", new Object[0]), 81, 832).setAutomatic();
        Shortcut.registerSystemShortcut("system:save", I18n.tr("reserved", new Object[0]), 83, 256);
        Shortcut.registerSystemShortcut("system:saveas", I18n.tr("reserved", new Object[0]), 83, 320);
        Shortcut.registerSystemShortcut("system:fonts", I18n.tr("reserved", new Object[0]), 84, 256);
        Shortcut.registerSystemShortcut("system:toggletoolbar", I18n.tr("reserved", new Object[0]), 84, 768);
        Shortcut.registerSystemShortcut("system:underline", I18n.tr("reserved", new Object[0]), 85, 256);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 256);
        Shortcut.registerSystemShortcut("system:pastestyle", I18n.tr("reserved", new Object[0]), 86, 768);
        Shortcut.registerSystemShortcut("system:pastemwithoutstyle", I18n.tr("reserved", new Object[0]), 86, 832);
        Shortcut.registerSystemShortcut("system:pasteformatting", I18n.tr("reserved", new Object[0]), 86, 384);
        Shortcut.registerSystemShortcut("system:closewindow", I18n.tr("reserved", new Object[0]), 87, 256);
        Shortcut.registerSystemShortcut("system:closefile", I18n.tr("reserved", new Object[0]), 87, 320);
        Shortcut.registerSystemShortcut("system:closeallwindows", I18n.tr("reserved", new Object[0]), 87, 768);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 256);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 256);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 90, 320);
        Shortcut.registerSystemShortcut("apple-reserved-45", I18n.tr("reserved", new Object[0]), 39, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        Shortcut.registerSystemShortcut("apple-reserved-49", I18n.tr("reserved", new Object[0]), 37, 256).setAutomatic();
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        Shortcut.registerSystemShortcut("system:about", I18n.tr("reserved", new Object[0]), 0, -1).setAutomatic();
        Shortcut.registerSystemShortcut("view:zoomin", I18n.tr("reserved", new Object[0]), 107, 256);
        Shortcut.registerSystemShortcut("view:zoomout", I18n.tr("reserved", new Object[0]), 109, 256);
    }

    public String makeTooltip(String string, Shortcut shortcut) {
        String string2 = UIManager.getLookAndFeel().getID();
        boolean bl = true;
        if (string2.contains("Mac") || string2.contains("Aqua")) {
            bl = false;
        }
        String string3 = "";
        if (bl) {
            string3 = string3 + "<html>";
        }
        string3 = string3 + string;
        if (shortcut != null && shortcut.getKeyText().length() != 0) {
            string3 = string3 + " ";
            if (bl) {
                string3 = string3 + "<font size='-2'>";
            }
            string3 = string3 + "(" + shortcut.getKeyText() + ")";
            if (bl) {
                string3 = string3 + "</font>";
            }
        }
        if (bl) {
            string3 = string3 + "&nbsp;</html>";
        }
        return string3;
    }

    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public boolean canFullscreen() {
        return false;
    }
}

