/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerLocationReader
extends OsmServerReader {
    String url;

    public OsmServerLocationReader(String string) {
        this.url = string;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream = null;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            inputStream = this.getInputStreamRaw(this.url, progressMonitor.createSubTaskMonitor(9, false));
            if (inputStream == null) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet3 = null;
                return dataSet3;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataSet;
    }

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        DataSet dataSet;
        InputStream inputStream = null;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            inputStream = this.getInputStreamRaw(this.url, progressMonitor.createSubTaskMonitor(9, false));
            if (inputStream == null) {
                DataSet dataSet2 = null;
                return dataSet2;
            }
            progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            dataSet = OsmChangeReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                DataSet dataSet3 = null;
                return dataSet3;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataSet;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        GpxData gpxData;
        InputStream inputStream = null;
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            inputStream = this.getInputStreamRaw(this.url, progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) {
                GpxData gpxData2 = null;
                return gpxData2;
            }
            progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            GpxReader gpxReader = new GpxReader(inputStream);
            gpxReader.parse(false);
            GpxData gpxData3 = gpxReader.data;
            gpxData3.fromServer = true;
            gpxData = gpxData3;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                GpxData gpxData4 = null;
                return gpxData4;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            try {
                this.activeConnection = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return gpxData;
    }
}

