/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GeoJSONWriter;
import org.openstreetmap.josm.tools.I18n;

public class GeoJSONExporter
extends FileExporter {
    public GeoJSONExporter() {
        super(new ExtensionFileFilter("json,geojson", "json", I18n.tr("GeoJSON Files", new Object[0]) + " (*.json *.geojson)"));
    }

    public void exportData(File file, Layer layer) throws IOException {
        if (!(layer instanceof OsmDataLayer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' not supported", layer.getClass().toString()));
        }
        String string = new GeoJSONWriter((OsmDataLayer)layer).write();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }
}

