/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    protected final double lat1;
    protected final double lon1;
    protected final double lat2;
    protected final double lon2;
    protected final boolean crosses180th;

    public BoundingBoxDownloader(Bounds bounds) {
        this.lat1 = bounds.getMin().lat();
        this.lon1 = bounds.getMin().lon();
        this.lat2 = bounds.getMax().lat();
        this.lon2 = bounds.getMax().lon();
        this.crosses180th = bounds.crosses180thMeridian();
    }

    private GpxData downloadRawGps(String string, ProgressMonitor progressMonitor) throws IOException, OsmTransferException, SAXException {
        boolean bl = false;
        GpxData gpxData = null;
        int n = 0;
        while (!bl) {
            progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", n * 5000, (n + 1) * 5000));
            InputStream inputStream = this.getInputStream(string + n, progressMonitor.createSubTaskMonitor(1, true));
            if (inputStream == null) break;
            progressMonitor.setTicks(0);
            GpxReader gpxReader = new GpxReader(inputStream);
            gpxReader.parse(false);
            GpxData gpxData2 = gpxReader.data;
            if (gpxData == null) {
                gpxData = gpxData2;
            } else if (gpxData2.hasTrackPoints()) {
                gpxData.mergeFrom(gpxData2);
            } else {
                bl = true;
            }
            inputStream.close();
            this.activeConnection = null;
            ++n;
        }
        gpxData.fromServer = true;
        return gpxData;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
            if (this.crosses180th) {
                GpxData gpxData = this.downloadRawGps("trackpoints?bbox=" + this.lon1 + "," + this.lat1 + ",180.0," + this.lat2 + "&page=", progressMonitor);
                gpxData.mergeFrom(this.downloadRawGps("trackpoints?bbox=-180.0," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=", progressMonitor));
                GpxData gpxData2 = gpxData;
                return gpxData2;
            }
            GpxData gpxData = this.downloadRawGps("trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=", progressMonitor);
            return gpxData;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException("Illegal characters within the HTTP-header response.", illegalArgumentException);
        }
        catch (IOException iOException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new OsmTransferException(iOException);
        }
        catch (SAXException sAXException) {
            throw new OsmTransferException(sAXException);
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (RuntimeException runtimeException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw runtimeException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    protected String getRequestForBbox(double d, double d2, double d3, double d4) {
        return "map?bbox=" + d + "," + d2 + "," + d3 + "," + d4;
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 10);
        InputStream inputStream = null;
        try {
            DataSet dataSet;
            DataSet dataSet2 = null;
            progressMonitor.indeterminateSubTask(null);
            if (this.crosses180th) {
                inputStream = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, 180.0, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                if (inputStream == null) {
                    DataSet dataSet3 = null;
                    return dataSet3;
                }
                dataSet2 = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
                inputStream = this.getInputStream(this.getRequestForBbox(-180.0, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                if (inputStream == null) {
                    DataSet dataSet4 = null;
                    return dataSet4;
                }
                dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
                if (dataSet == null) {
                    DataSet dataSet5 = null;
                    return dataSet5;
                }
                dataSet2.mergeFrom(dataSet);
            } else {
                inputStream = this.getInputStream(this.getRequestForBbox(this.lon1, this.lat1, this.lon2, this.lat2), progressMonitor.createSubTaskMonitor(9, false));
                if (inputStream == null) {
                    DataSet dataSet6 = null;
                    return dataSet6;
                }
                dataSet2 = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
            }
            dataSet = dataSet2;
            return dataSet;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.activeConnection = null;
        }
    }
}

