/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.tools.Utils;

public class SourceEntry {
    public String url;
    public String name;
    public String title;
    public boolean active;

    public SourceEntry(String string, String string2, String string3, Boolean bl) {
        this.url = string;
        this.name = Utils.equal(string2, "") ? null : string2;
        this.title = Utils.equal(string3, "") ? null : string3;
        this.active = bl;
    }

    public SourceEntry(SourceEntry sourceEntry) {
        this.url = sourceEntry.url;
        this.name = sourceEntry.name;
        this.title = sourceEntry.title;
        this.active = sourceEntry.active;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SourceEntry sourceEntry = (SourceEntry)object;
        return Utils.equal(sourceEntry.url, this.url) && Utils.equal(sourceEntry.name, this.name) && Utils.equal(sourceEntry.title, this.title) && sourceEntry.active == this.active;
    }

    public int hashCode() {
        int n = 5;
        n = 89 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 89 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 89 * n + (this.title != null ? this.title.hashCode() : 0);
        n = 89 * n + (this.active ? 1 : 0);
        return n;
    }

    public String toString() {
        return this.title != null ? this.title : this.url;
    }

    public String getDisplayString() {
        if (this.title != null) {
            return this.title;
        }
        return this.getFileNamePart();
    }

    public String getFileNamePart() {
        Pattern pattern = Pattern.compile("([^/\\\\]*?)([?].*)?$");
        Matcher matcher = pattern.matcher(this.url);
        if (matcher.find()) {
            return matcher.group(1);
        }
        System.err.println("Warning: Unexpected URL format: " + this.url);
        return this.url;
    }

    public String getPrefName() {
        return this.name == null ? "standard" : this.name;
    }

    public boolean isLocal() {
        return !this.url.startsWith("http://") && !this.url.startsWith("resource://");
    }

    public String getLocalSourceDir() {
        if (!this.isLocal()) {
            return null;
        }
        File file = new File(this.url);
        File file2 = file.getParentFile();
        if (file2 == null) {
            return null;
        }
        return file2.getPath();
    }
}

