/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;
    private static String ZERO_CHAR_STRING;

    public FileDrop(Component component) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, new Listener(){

            public void filesDropped(File[] fileArray) {
                OpenFileAction.OpenFileTask openFileTask = new OpenFileAction.OpenFileTask(Arrays.asList(fileArray), null);
                openFileTask.setRecordHistory(true);
                Main.worker.submit(openFileTask);
            }
        });
    }

    public FileDrop(Component component, Listener listener) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component component, boolean bl, Listener listener) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), bl, listener);
    }

    public FileDrop(PrintStream printStream, Component component, Listener listener) {
        this(printStream, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(PrintStream printStream, Component component, boolean bl, Listener listener) {
        this(printStream, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), bl, listener);
    }

    public FileDrop(Component component, Border border, Listener listener) {
        this(null, component, border, false, listener);
    }

    public FileDrop(Component component, Border border, boolean bl, Listener listener) {
        this(null, component, border, bl, listener);
    }

    public FileDrop(PrintStream printStream, Component component, Border border, Listener listener) {
        this(printStream, component, border, false, listener);
    }

    public FileDrop(final PrintStream printStream, final Component component, final Border border, boolean bl, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(printStream, "FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(printStream, dropTargetDragEvent)) {
                        if (component instanceof JComponent) {
                            JComponent jComponent = (JComponent)component;
                            FileDrop.this.normalBorder = jComponent.getBorder();
                            FileDrop.log(printStream, "FileDrop: normal border saved.");
                            jComponent.setBorder(border);
                            FileDrop.log(printStream, "FileDrop: drag border set.");
                        }
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(printStream, "FileDrop: event accepted.");
                    } else {
                        dropTargetDragEvent.rejectDrag();
                        FileDrop.log(printStream, "FileDrop: event rejected.");
                    }
                }

                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    FileDrop.log(printStream, "FileDrop: drop event.");
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            dropTargetDropEvent.acceptDrop(1);
                            FileDrop.log(printStream, "FileDrop: file list accepted.");
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            File[] fileArray = list.toArray(new File[list.size()]);
                            if (listener != null) {
                                listener.filesDropped(fileArray);
                            }
                            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                            FileDrop.log(printStream, "FileDrop: drop complete.");
                        } else {
                            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                            boolean bl = false;
                            for (int i = 0; i < dataFlavorArray.length; ++i) {
                                if (!dataFlavorArray[i].isRepresentationClassReader()) continue;
                                dropTargetDropEvent.acceptDrop(1);
                                FileDrop.log(printStream, "FileDrop: reader accepted.");
                                Reader reader = dataFlavorArray[i].getReaderForText(transferable);
                                BufferedReader bufferedReader = new BufferedReader(reader);
                                if (listener != null) {
                                    listener.filesDropped(FileDrop.createFileArray(bufferedReader, printStream));
                                }
                                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                                FileDrop.log(printStream, "FileDrop: drop complete.");
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                FileDrop.log(printStream, "FileDrop: not a file list or reader - abort.");
                                dropTargetDropEvent.rejectDrop();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        FileDrop.log(printStream, "FileDrop: IOException - abort:");
                        iOException.printStackTrace(printStream);
                        dropTargetDropEvent.rejectDrop();
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        FileDrop.log(printStream, "FileDrop: UnsupportedFlavorException - abort:");
                        unsupportedFlavorException.printStackTrace(printStream);
                        dropTargetDropEvent.rejectDrop();
                    }
                    finally {
                        if (component instanceof JComponent) {
                            JComponent jComponent = (JComponent)component;
                            jComponent.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(printStream, "FileDrop: normal border restored.");
                        }
                    }
                }

                public void dragExit(DropTargetEvent dropTargetEvent) {
                    FileDrop.log(printStream, "FileDrop: dragExit event.");
                    if (component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(printStream, "FileDrop: normal border restored.");
                    }
                }

                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(printStream, "FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(printStream, dropTargetDragEvent)) {
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(printStream, "FileDrop: event accepted.");
                    } else {
                        dropTargetDragEvent.rejectDrag();
                        FileDrop.log(printStream, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(printStream, component, bl);
        } else {
            FileDrop.log(printStream, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean bl = false;
            try {
                Class.forName("java.awt.dnd.DnDConstants");
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            supportsDnD = bl;
        }
        return supportsDnD;
    }

    private static File[] createFileArray(BufferedReader bufferedReader, PrintStream printStream) {
        try {
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(string)) continue;
                    File file = new File(new URI(string));
                    arrayList.add(file);
                }
                catch (Exception exception) {
                    FileDrop.log(printStream, "Error with " + string + ": " + exception.getMessage());
                }
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        catch (IOException iOException) {
            FileDrop.log(printStream, "FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final PrintStream printStream, final Component component, boolean bl) {
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
            FileDrop.log(printStream, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        component.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                FileDrop.log(printStream, "FileDrop: Hierarchy changed.");
                Container container = component.getParent();
                if (container == null) {
                    component.setDropTarget(null);
                    FileDrop.log(printStream, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(component, FileDrop.this.dropListener);
                    FileDrop.log(printStream, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this.dropListener);
        }
        if (bl && component instanceof Container) {
            Container container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.makeDropTarget(printStream, componentArray[i], bl);
            }
        }
    }

    private boolean isDragOk(PrintStream printStream, DropTargetDragEvent dropTargetDragEvent) {
        int n;
        boolean bl = false;
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        for (n = 0; !bl && n < dataFlavorArray.length; ++n) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor) && !dataFlavor.isRepresentationClassReader()) continue;
            bl = true;
        }
        if (printStream != null) {
            if (dataFlavorArray.length == 0) {
                FileDrop.log(printStream, "FileDrop: no data flavors.");
            }
            for (n = 0; n < dataFlavorArray.length; ++n) {
                FileDrop.log(printStream, dataFlavorArray[n].toString());
            }
        }
        return bl;
    }

    private static void log(PrintStream printStream, String string) {
        if (printStream != null) {
            printStream.println(string);
        }
    }

    public static boolean remove(Component component) {
        return FileDrop.remove(null, component, true);
    }

    public static boolean remove(PrintStream printStream, Component component, boolean bl) {
        if (FileDrop.supportsDnD()) {
            FileDrop.log(printStream, "FileDrop: Removing drag-and-drop hooks.");
            component.setDropTarget(null);
            if (bl && component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    FileDrop.remove(printStream, componentArray[i], bl);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        ZERO_CHAR_STRING = "\u0000";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransferableObject
    implements Transferable {
        public static final String MIME_TYPE = "application/x-net.iharder.dnd.TransferableObject";
        public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.dnd.TransferableObject");
        private Fetcher fetcher;
        private Object data;
        private DataFlavor customFlavor;

        public TransferableObject(Object object) {
            this.data = object;
            this.customFlavor = new DataFlavor(object.getClass(), MIME_TYPE);
        }

        public TransferableObject(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        public TransferableObject(Class<?> clazz, Fetcher fetcher) {
            this.fetcher = fetcher;
            this.customFlavor = new DataFlavor(clazz, MIME_TYPE);
        }

        public DataFlavor getCustomDataFlavor() {
            return this.customFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.customFlavor != null) {
                return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(DATA_FLAVOR)) {
                return this.fetcher == null ? this.data : this.fetcher.getObject();
            }
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DATA_FLAVOR)) {
                return true;
            }
            return dataFlavor.equals(DataFlavor.stringFlavor);
        }

        public static interface Fetcher {
            public Object getObject();
        }
    }

    public static class Event
    extends EventObject {
        private File[] files;

        public Event(File[] fileArray, Object object) {
            super(object);
            this.files = fileArray;
        }

        public File[] getFiles() {
            return this.files;
        }
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

