/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UntaggedNode
extends Test {
    protected static final int UNTAGGED_NODE_BLANK = 201;
    protected static final int UNTAGGED_NODE_FIXME = 202;
    protected static final int UNTAGGED_NODE_NOTE = 203;
    protected static final int UNTAGGED_NODE_CREATED_BY = 204;
    protected static final int UNTAGGED_NODE_WATCH = 205;
    protected static final int UNTAGGED_NODE_SOURCE = 206;
    protected static final int UNTAGGED_NODE_OTHER = 207;

    public UntaggedNode() {
        super(I18n.tr("Untagged and unconnected nodes", new Object[0]), I18n.tr("This test checks for untagged nodes that are not part of any way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (!osmPrimitive.isUsable() || !(osmPrimitive instanceof Node)) continue;
            osmPrimitive.visit(this);
        }
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && !node.isTagged() && node.getReferrers().isEmpty()) {
            if (!node.hasKeys()) {
                String string = I18n.marktr("No tags");
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unconnected nodes without physical tags", new Object[0]), I18n.tr(string, new Object[0]), string, 201, node));
                return;
            }
            for (Map.Entry<String, String> entry : node.getKeys().entrySet()) {
                String string;
                String string2 = entry.getKey();
                if (this.contains(entry, "fixme") || this.contains(entry, "FIXME")) {
                    string = I18n.marktr("Has tag containing ''fixme'' or ''FIXME''");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unconnected nodes without physical tags", new Object[0]), I18n.tr(string, new Object[0]), string, 202, node));
                    return;
                }
                string = null;
                int n = 0;
                if (string2.startsWith("note") || string2.startsWith("comment") || string2.startsWith("description")) {
                    string = I18n.marktr("Has key ''note'' or ''comment'' or ''description''");
                    n = 203;
                } else if (string2.startsWith("created_by") || string2.startsWith("converted_by")) {
                    string = I18n.marktr("Has key ''created_by'' or ''converted_by''");
                    n = 204;
                } else if (string2.startsWith("watch")) {
                    string = I18n.marktr("Has key ''watch''");
                    n = 205;
                } else if (string2.startsWith("source")) {
                    string = I18n.marktr("Has key ''source''");
                    n = 206;
                }
                if (string == null) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unconnected nodes without physical tags", new Object[0]), I18n.tr(string, new Object[0]), string, n, node));
                return;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unconnected nodes without physical tags", new Object[0]), I18n.tr("Other", new Object[0]), "Other", 207, node));
        }
    }

    private boolean contains(Map.Entry<String, String> entry, String string) {
        return entry.getKey().indexOf(string) != -1 || entry.getValue().indexOf(string) != -1;
    }

    @Override
    public Command fixError(TestError testError) {
        return DeleteCommand.delete(Main.map.mapView.getEditLayer(), testError.getPrimitives());
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedNode) {
            int n = testError.getCode();
            switch (n) {
                case 201: 
                case 204: 
                case 205: 
                case 206: {
                    return true;
                }
            }
        }
        return false;
    }
}

