/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMismatch
extends Test {
    protected static final int NAME_MISSING = 1501;
    protected static final int NAME_TRANSLATION_MISSING = 1502;

    public NameMismatch() {
        super(I18n.tr("Missing name:* translation", new Object[0]), I18n.tr("This test finds multilingual objects whose ''name'' attribute is not equal to some ''name:*'' attribute and not a composition of ''name:*'' attributes, e.g., Italia - Italien - Italy.", new Object[0]));
    }

    private void missingTranslation(OsmPrimitive osmPrimitive) {
        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("A name:* translation is missing.", new Object[0]), 1502, osmPrimitive));
    }

    public void check(OsmPrimitive osmPrimitive) {
        HashSet<String[]> hashSet = new HashSet<String[]>();
        for (Map.Entry<String, String> stringArray2 : osmPrimitive.getKeys().entrySet()) {
            String[] stringArray;
            if (!stringArray2.getKey().startsWith("name:") || (stringArray = stringArray2.getValue()) == null) continue;
            hashSet.add(stringArray);
        }
        if (hashSet.isEmpty()) {
            return;
        }
        String string = osmPrimitive.get("name");
        if (string == null) {
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("A name is missing, even though name:* exists.", new Object[0]), 1501, osmPrimitive));
            return;
        }
        if (hashSet.contains(string)) {
            return;
        }
        String[] stringArray = string.split(" - ");
        if (stringArray.length == 1) {
            this.missingTranslation(osmPrimitive);
            return;
        }
        for (String string2 : stringArray) {
            if (hashSet.contains(string2)) continue;
            this.missingTranslation(osmPrimitive);
            return;
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isDeleted() || osmPrimitive.isIncomplete()) continue;
            this.check(osmPrimitive);
        }
    }
}

