/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagCollection
implements Iterable<Tag> {
    private final HashSet<Tag> tags = new HashSet();

    public static TagCollection from(Tagged tagged) {
        TagCollection tagCollection = new TagCollection();
        for (String string : tagged.keySet()) {
            tagCollection.add(new Tag(string, tagged.get(string)));
        }
        return tagCollection;
    }

    public static TagCollection from(Map<String, String> map) {
        TagCollection tagCollection = new TagCollection();
        if (map == null) {
            return tagCollection;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey() == null ? "" : entry.getKey();
            String string2 = entry.getValue() == null ? "" : entry.getValue();
            tagCollection.add(new Tag(string, string2));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(Collection<? extends Tagged> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (Tagged tagged : collection) {
            if (tagged == null) continue;
            tagCollection.add(TagCollection.from(tagged));
        }
        return tagCollection;
    }

    public static TagCollection commonToAllPrimitives(Collection<? extends Tagged> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null || collection.isEmpty()) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.from(collection.iterator().next()));
        for (Tagged tagged : collection) {
            if (tagged == null) continue;
            tagCollection.add(tagCollection.intersect(TagCollection.from(tagged)));
        }
        return tagCollection;
    }

    public static TagCollection unionOfAllPrimitives(DataSet dataSet) {
        TagCollection tagCollection = new TagCollection();
        if (dataSet == null) {
            return tagCollection;
        }
        tagCollection.add(TagCollection.unionOfAllPrimitives(dataSet.allPrimitives()));
        return tagCollection;
    }

    public TagCollection() {
    }

    public TagCollection(TagCollection tagCollection) {
        if (tagCollection != null) {
            this.tags.addAll(tagCollection.tags);
        }
    }

    public int size() {
        return this.tags.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void add(Tag tag) {
        if (tag == null) {
            return;
        }
        if (this.tags.contains(tag)) {
            return;
        }
        this.tags.add(tag);
    }

    public void add(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        for (Tag tag : collection) {
            this.add(tag);
        }
    }

    public void add(TagCollection tagCollection) {
        if (tagCollection == null) {
            return;
        }
        this.tags.addAll(tagCollection.tags);
    }

    public void remove(Tag tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void remove(Collection<Tag> collection) {
        if (collection == null) {
            return;
        }
        this.tags.removeAll(collection);
    }

    public void remove(TagCollection tagCollection) {
        if (tagCollection == null) {
            return;
        }
        this.tags.removeAll(tagCollection.tags);
    }

    public void removeByKey(String string) {
        if (string == null) {
            return;
        }
        Iterator<Tag> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().matchesKey(string)) continue;
            iterator.remove();
        }
    }

    public void removeByKey(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        for (String string : collection) {
            this.removeByKey(string);
        }
    }

    public boolean contains(Tag tag) {
        return this.tags.contains(tag);
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Tag> collection) {
        if (collection == null) {
            return false;
        }
        return this.tags.containsAll(collection);
    }

    public boolean containsAllKeys(Collection<String> collection) {
        if (collection == null) {
            return false;
        }
        for (String string : collection) {
            if (string == null || this.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    public int getNumTagsFor(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasTagsFor(String string) {
        return this.getNumTagsFor(string) > 0;
    }

    public boolean hasValuesFor(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        set.remove("");
        return !set.isEmpty();
    }

    public boolean hasUniqueNonEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.size() == 1 && !set.contains("");
    }

    public boolean hasEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.contains("");
    }

    public boolean hasUniqueEmptyValue(String string) {
        if (string == null) {
            return false;
        }
        Set<String> set = this.getTagsFor(string).getValues();
        return set.size() == 1 && set.contains("");
    }

    public TagCollection getTagsFor(String string) {
        TagCollection tagCollection = new TagCollection();
        if (string == null) {
            return tagCollection;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            tagCollection.add(tag);
        }
        return tagCollection;
    }

    public TagCollection getTagsFor(Collection<String> collection) {
        TagCollection tagCollection = new TagCollection();
        if (collection == null) {
            return tagCollection;
        }
        for (String string : collection) {
            if (string == null) continue;
            tagCollection.add(this.getTagsFor(string));
        }
        return tagCollection;
    }

    public Set<Tag> asSet() {
        return new HashSet<Tag>(this.tags);
    }

    public List<Tag> asList() {
        return new ArrayList<Tag>(this.tags);
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tags.iterator();
    }

    public Set<String> getKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Tag tag : this.tags) {
            hashSet.add(tag.getKey());
        }
        return hashSet;
    }

    public Set<String> getKeysWithMultipleValues() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Tag object : this.tags) {
            Integer n = (Integer)hashMap.get(object.getKey());
            hashMap.put(object.getKey(), n == null ? 1 : n + 1);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public void setUniqueForKey(Tag tag) {
        if (tag == null) {
            return;
        }
        this.removeByKey(tag.getKey());
        this.add(tag);
    }

    public void setUniqueForKey(String string, String string2) {
        Tag tag = new Tag(string, string2);
        this.setUniqueForKey(tag);
    }

    public Set<String> getValues() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Tag tag : this.tags) {
            hashSet.add(tag.getValue());
        }
        return hashSet;
    }

    public Set<String> getValues(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null) {
            return hashSet;
        }
        for (Tag tag : this.tags) {
            if (!tag.matchesKey(string)) continue;
            hashSet.add(tag.getValue());
        }
        return hashSet;
    }

    public boolean isApplicableToPrimitive() {
        return this.size() == this.getKeys().size();
    }

    public void applyTo(Tagged tagged) throws IllegalStateException {
        if (tagged == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
        for (Tag tag : this.tags) {
            if (tag.getValue() == null || tag.getValue().equals("")) {
                tagged.remove(tag.getKey());
                continue;
            }
            tagged.put(tag.getKey(), tag.getValue());
        }
    }

    public void applyTo(Collection<? extends Tagged> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
        for (Tagged tagged : collection) {
            this.applyTo(tagged);
        }
    }

    public void replaceTagsOf(Tagged tagged) throws IllegalStateException {
        if (tagged == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
        tagged.removeAll();
        for (Tag tag : this.tags) {
            tagged.put(tag.getKey(), tag.getValue());
        }
    }

    public void replaceTagsOf(Collection<? extends Tagged> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        if (!this.isApplicableToPrimitive()) {
            throw new IllegalStateException(I18n.tr("Tag collection cannot be applied to a primitive because there are keys with multiple values.", new Object[0]));
        }
        for (Tagged tagged : collection) {
            this.replaceTagsOf(tagged);
        }
    }

    public TagCollection intersect(TagCollection tagCollection) {
        if (tagCollection == null) {
            tagCollection = new TagCollection();
        }
        TagCollection tagCollection2 = new TagCollection(this);
        for (Tag tag : this.tags) {
            if (!tagCollection.contains(tag)) continue;
            tagCollection2.add(tag);
        }
        return tagCollection2;
    }

    public TagCollection minus(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.remove(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection union(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection(this);
        if (tagCollection != null) {
            tagCollection2.add(tagCollection);
        }
        return tagCollection2;
    }

    public TagCollection emptyTagsForKeysMissingIn(TagCollection tagCollection) {
        TagCollection tagCollection2 = new TagCollection();
        for (String string : this.minus(tagCollection).getKeys()) {
            tagCollection2.add(new Tag(string));
        }
        return tagCollection2;
    }

    public String getJoinedValues(String string) {
        Set<String> set = this.getValues(string);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        for (String object : set) {
            List<String> list = Arrays.asList(object.split(";\\s*"));
            linkedHashMap.put(object, list);
            linkedHashSet.addAll(list);
        }
        linkedHashSet.remove("");
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (!((Collection)entry.getValue()).containsAll(linkedHashSet)) continue;
            return (String)entry.getKey();
        }
        return Utils.join(";", linkedHashSet);
    }

    public String toString() {
        return this.tags.toString();
    }
}

