/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Node lastUsedNode = null;
    private double PHI = Math.toRadians(90.0);
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private Set<OsmPrimitive> newHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private Point mousePos;
    private Point oldMousePos;
    private Color selectedColor;
    private Node currentBaseNode;
    private Node previousNode;
    private EastNorth currentMouseEastNorth;
    private SnapHelper snapHelper = new SnapHelper();
    private Shortcut backspaceShortcut;
    private Shortcut snappingShortcut;
    private JCheckBoxMenuItem snapCheckboxMenuItem;
    private final TreeSet<Integer> set = new TreeSet();
    private KeyEvent releaseEvent;
    private Timer timer;
    private Point rightClickPressPos;

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw", new Object[0]), "node/autonode", I18n.tr("Draw nodes", new Object[0]), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw", new Object[0])), 65, 5003), mapFrame, ImageProvider.getCursor("crosshair", null));
        this.snappingShortcut = Shortcut.registerShortcut("mapmode:drawanglesnapping", I18n.tr("Mode: Draw Angle snapping", new Object[0]), 9, 5003);
        this.addMenuItem();
        this.snapHelper.setMenuCheckBox(this.snapCheckboxMenuItem);
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
    }

    private void addMenuItem() {
        int n = Main.main.menu.editMenu.getItemCount();
        for (int i = n - 1; i > 0; --i) {
            JMenuItem jMenuItem = Main.main.menu.editMenu.getItem(i);
            if (jMenuItem == null || jMenuItem.getAction() == null || !(jMenuItem.getAction() instanceof SnapChangeAction)) continue;
            Main.main.menu.editMenu.remove(i);
        }
        this.snapCheckboxMenuItem = MainMenu.addWithCheckbox(Main.main.menu.editMenu, new SnapChangeAction(), MainMenu.WINDOW_MENU_GROUP.VOLATILE);
    }

    private boolean redrawIfRequired() {
        boolean bl;
        this.updateStatusLine();
        boolean bl2 = bl = this.drawHelperLine && !this.wayIsFinished;
        if (this.drawTargetHighlight) {
            for (OsmPrimitive osmPrimitive : this.newHighlights) {
                if (this.oldHighlights.contains(osmPrimitive)) continue;
                osmPrimitive.setHighlighted(true);
                bl = true;
            }
            this.oldHighlights.removeAll(this.newHighlights);
            for (OsmPrimitive osmPrimitive : this.oldHighlights) {
                osmPrimitive.setHighlighted(false);
                bl = true;
            }
        }
        this.oldHighlights = this.newHighlights;
        if (!bl && !this.drawTargetHighlight) {
            return false;
        }
        if (this.currentBaseNode != null && !DrawAction.getCurrentDataSet().getSelected().isEmpty()) {
            Way way = DrawAction.getWayForNode(this.currentBaseNode);
            if (this.alt && way != null && (!this.currentBaseNode.isSelected() || way.isSelected())) {
                DrawAction.getCurrentDataSet().beginUpdate();
                DrawAction.getCurrentDataSet().addSelected(this.currentBaseNode);
                DrawAction.getCurrentDataSet().clearSelection(way);
                DrawAction.getCurrentDataSet().endUpdate();
                bl = true;
            } else if (!this.alt && way != null && !way.isSelected()) {
                DrawAction.getCurrentDataSet().addSelected(way);
                bl = true;
            }
        }
        if (bl) {
            Main.map.mapView.repaint();
        }
        return bl;
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.selectedColor = PaintColors.SELECTED.get();
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.determineCurrentBaseNodeAndPreviousNode(DrawAction.getCurrentDataSet().getSelected());
        this.wayIsFinished = this.currentBaseNode == null;
        this.snapHelper.init();
        this.snapCheckboxMenuItem.getAction().setEnabled(true);
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawAction.this.timer.stop();
                if (DrawAction.this.set.remove(DrawAction.this.releaseEvent.getKeyCode())) {
                    DrawAction.this.doKeyReleaseEvent(DrawAction.this.releaseEvent);
                }
            }
        });
        Main.map.statusLine.getAnglePanel().addMouseListener(this.snapHelper.anglePopupListener);
        this.backspaceShortcut = Shortcut.registerShortcut("mapmode:backspace", I18n.tr("Backspace in Add mode", new Object[0]), 8, 5003);
        Main.registerActionShortcut(new BackSpaceAction(), this.backspaceShortcut);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.addSelectionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.removeSelectionListener(this);
        Main.unregisterActionShortcut(this.backspaceShortcut);
        this.snapHelper.unsetFixedMode();
        this.snapCheckboxMenuItem.getAction().setEnabled(false);
        Main.map.statusLine.getAnglePanel().removeMouseListener(this.snapHelper.anglePopupListener);
        Main.map.statusLine.activateAnglePanel(false);
        this.removeHighlighting();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DataSet dataSet = DrawAction.getCurrentDataSet();
        if (dataSet != null) {
            dataSet.fireSelectionChanged();
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        Component component;
        KeyEvent keyEvent;
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        if (aWTEvent instanceof KeyEvent && (this.snappingShortcut.isEvent(keyEvent = (KeyEvent)aWTEvent) || this.getShortcut().isEvent(keyEvent)) && SwingUtilities.getWindowAncestor(component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JFrame) {
            this.processKeyEvent(keyEvent);
        }
        this.updateKeyModifiers((InputEvent)aWTEvent);
        this.computeHelperLine();
        this.addHighlighting();
    }

    void processKeyEvent(KeyEvent keyEvent) {
        if (!this.snappingShortcut.isEvent(keyEvent) && !this.getShortcut().isEvent(keyEvent)) {
            return;
        }
        if (keyEvent.getID() == 401) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            } else if (this.set.add(keyEvent.getKeyCode())) {
                this.doKeyPressEvent(keyEvent);
            }
        } else if (keyEvent.getID() == 402) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                if (this.set.remove(keyEvent.getKeyCode())) {
                    this.doKeyReleaseEvent(keyEvent);
                }
            } else {
                this.releaseEvent = keyEvent;
                this.timer.restart();
            }
        }
    }

    private void doKeyPressEvent(KeyEvent keyEvent) {
        this.snapHelper.setFixedMode();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    private void doKeyReleaseEvent(KeyEvent keyEvent) {
        this.snapHelper.unFixOrTurnOff();
        this.computeHelperLine();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void tryAgain(MouseEvent mouseEvent) {
        DrawAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.mouseReleased(mouseEvent);
    }

    private void finishDrawing() {
        Main.main.getCurrentDataSet().fireSelectionChanged();
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        Main.map.selectSelectTool(true);
        this.snapHelper.noSnapNow();
        this.computeHelperLine();
        this.removeHighlighting();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.rightClickPressPos = mouseEvent.getPoint();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        Object object3;
        if (mouseEvent.getButton() == 3) {
            WaySegment waySegment;
            Point point = mouseEvent.getPoint();
            if (point.equals(this.rightClickPressPos) && (waySegment = Main.map.mapView.getNearestWaySegment(point, OsmPrimitive.isSelectablePredicate)) != null) {
                this.snapHelper.setBaseSegment(waySegment);
                this.computeHelperLine();
                this.redrawIfRequired();
            }
            return;
        }
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Main.map.mapView.requestFocus();
        if (mouseEvent.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        DataSet dataSet = DrawAction.getCurrentDataSet();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(dataSet.getSelected());
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>(dataSet.getSelected());
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        ArrayList<Way> arrayList3 = new ArrayList<Way>();
        boolean bl = false;
        Node node = null;
        if (!this.ctrl) {
            node = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (node != null && !this.snapHelper.isActive()) {
            if (arrayList.isEmpty() || this.wayIsFinished) {
                DrawAction.getCurrentDataSet().setSelected(node);
                Way way = DrawAction.getWayForNode(node);
                if (way != null) {
                    DrawAction.getCurrentDataSet().addSelected(way);
                }
                this.wayIsFinished = false;
                return;
            }
        } else {
            EastNorth eastNorth;
            if (node != null) {
                eastNorth = node.getEastNorth();
                if (eastNorth.distance((EastNorth)(object3 = this.snapHelper.getSnapPoint(eastNorth))) > 1.0E-4) {
                    node = new Node((EastNorth)object3);
                    bl = true;
                }
            } else {
                eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
                object3 = this.snapHelper.isSnapOn() ? this.snapHelper.getSnapPoint(eastNorth) : eastNorth;
                node = new Node((EastNorth)object3);
                bl = true;
            }
            this.snapHelper.unsetFixedMode();
        }
        if (bl) {
            if (node.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            linkedList.add(new AddCommand(node));
            if (!this.ctrl) {
                object3 = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node), OsmPrimitive.isSelectablePredicate);
                if (this.snapHelper.isActive()) {
                    this.tryToMoveNodeOnIntersection((List<WaySegment>)object3, node);
                }
                this.insertNodeIntoAllNearbySegments((List<WaySegment>)object3, node, linkedList2, linkedList, arrayList3, arrayList2);
            }
        }
        boolean bl2 = false;
        boolean bl3 = this.wayIsFinished;
        this.wayIsFinished = false;
        if (arrayList.size() > 0 && !this.shift) {
            object2 = null;
            object = null;
            for (OsmPrimitive osmPrimitive : arrayList) {
                if (osmPrimitive instanceof Node) {
                    if (object2 != null) {
                        this.tryAgain(mouseEvent);
                        return;
                    }
                    object2 = (Node)osmPrimitive;
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                if (object != null) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                object = (Way)osmPrimitive;
            }
            Node node2 = this.findNodeToContinueFrom((Node)object2, (Way)object);
            if (node2 == null) {
                this.tryAgain(mouseEvent);
                return;
            }
            if (!bl3) {
                void var15_30;
                Way way;
                void var15_26;
                int n;
                Object object4;
                if (this.isSelfContainedWay((Way)object, node2, node)) {
                    return;
                }
                if (node2 == node) {
                    this.finishDrawing();
                    return;
                }
                Object object5 = this.alt ? null : (object4 = object != null ? object : DrawAction.getWayForNode(node2));
                if (object4 != null) {
                    n = 0;
                    for (Node node3 : ((Way)object4).getNodes()) {
                        if (!node3.equals(node2)) continue;
                        ++n;
                    }
                    if (n > 1) {
                        Object var15_25 = null;
                    }
                }
                if (var15_26 == null) {
                    Way way2 = new Way();
                    way2.addNode(node2);
                    linkedList.add(new AddCommand(way2));
                    way = way2;
                } else {
                    n = arrayList3.indexOf(var15_26);
                    if (n != -1) {
                        Way way3;
                        way = way3 = arrayList2.get(n);
                    } else {
                        way = var15_26;
                        Way way4 = new Way((Way)var15_26);
                        linkedList.add(new ChangeCommand((OsmPrimitive)var15_26, way4));
                        Way way5 = way4;
                    }
                }
                if (var15_30.containsNode(node)) {
                    this.wayIsFinished = true;
                    arrayList.clear();
                }
                if (var15_30.getNode(var15_30.getNodesCount() - 1) == node2) {
                    var15_30.addNode(node);
                } else {
                    var15_30.addNode(0, node);
                }
                bl2 = true;
                linkedList2.clear();
                linkedList2.add(way);
            }
        }
        if (!bl2) {
            if (!bl) {
                return;
            }
            if (arrayList2.isEmpty()) {
                object2 = I18n.tr("Add node", new Object[0]);
            } else {
                object2 = I18n.tr("Add node into way", new Object[0]);
                for (Way way : arrayList2) {
                    linkedList2.remove(way);
                }
            }
            linkedList2.clear();
            linkedList2.add(node);
        } else {
            object2 = !bl ? I18n.tr("Connect existing way to node", new Object[0]) : (arrayList2.isEmpty() ? I18n.tr("Add a new node to an existing way", new Object[0]) : I18n.tr("Add node into way and connect", new Object[0]));
        }
        object = new SequenceCommand((String)object2, linkedList);
        Main.main.undoRedo.add((Command)object);
        if (!this.wayIsFinished) {
            this.lastUsedNode = node;
        }
        DrawAction.getCurrentDataSet().setSelected(linkedList2);
        if (node != null && Main.map.mapView.viewportFollowing) {
            Main.map.mapView.smoothScrollTo(node.getEastNorth());
        }
        this.computeHelperLine();
        this.removeHighlighting();
    }

    /*
     * WARNING - void declaration
     */
    private void insertNodeIntoAllNearbySegments(List<WaySegment> list, Node node, Collection<OsmPrimitive> collection, Collection<Command> collection2, ArrayList<Way> arrayList, ArrayList<Way> arrayList2) {
        HashMap hashMap = new HashMap();
        for (WaySegment object : list) {
            void var10_11;
            if (hashMap.containsKey(object.way)) {
                List list2 = (List)hashMap.get(object.way);
            } else {
                ArrayList arrayList3 = new ArrayList();
                hashMap.put(object.way, arrayList3);
            }
            var10_11.add(object.lowerIndex);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : hashMap.entrySet()) {
            int n;
            Way way = (Way)entry.getKey();
            List list3 = (List)entry.getValue();
            Way way2 = new Way(way);
            DrawAction.pruneSuccsAndReverse(list3);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                hashSet.add(Pair.sort(new Pair<Node, Node>(way.getNode(n), way.getNode(n + 1))));
            }
            iterator = list3.iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                way2.addNode(n + 1, node);
            }
            if (this.alt) {
                collection.add((OsmPrimitive)entry.getKey());
            }
            collection2.add(new ChangeCommand((OsmPrimitive)entry.getKey(), way2));
            arrayList.add((Way)entry.getKey());
            arrayList2.add(way2);
        }
        DrawAction.adjustNode(hashSet, node);
    }

    private boolean isSelfContainedWay(Way way, Node node, Node node2) {
        int n;
        if (way != null && ((n = way.getNodes().indexOf(node)) != -1 && n >= 1 && node2.equals(way.getNode(n - 1)) || n < way.getNodesCount() - 1 && node2.equals(way.getNode(n + 1)))) {
            DrawAction.getCurrentDataSet().setSelected(node2);
            this.lastUsedNode = node2;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node node, Way way) {
        if (node == null && way == null) {
            return null;
        }
        if (node == null) {
            if (way.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (way == null) {
            return node;
        }
        if (way.isFirstLastNode(node)) {
            return node;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        this.computeHelperLine();
        this.addHighlighting();
    }

    private void computeHelperLine() {
        MapView mapView = Main.map.mapView;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        Collection<OsmPrimitive> collection = DrawAction.getCurrentDataSet().getSelected();
        Node node = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        this.showStatusInfo(-1.0, -1.0, -1.0, this.snapHelper.isSnapOn());
        if (!this.ctrl && this.mousePos != null) {
            node = mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (!this.ctrl && node == null) {
            List<WaySegment> list = mapView.getNearestWaySegments(this.mousePos, OsmPrimitive.isSelectablePredicate);
            for (WaySegment waySegment : list) {
                this.mouseOnExistingWays.add(waySegment.way);
            }
        }
        if (node != null) {
            if (collection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = node.getEastNorth();
            this.mouseOnExistingNode = node;
        } else {
            this.currentMouseEastNorth = mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        this.determineCurrentBaseNodeAndPreviousNode(collection);
        if (this.previousNode == null) {
            this.snapHelper.noSnapNow();
        }
        if (this.currentBaseNode == null || this.currentBaseNode == node) {
            return;
        }
        double d = Math.toDegrees(this.currentBaseNode.getEastNorth().heading(this.currentMouseEastNorth));
        double d2 = -1.0;
        if (this.previousNode != null) {
            d2 = Math.toDegrees(this.previousNode.getEastNorth().heading(this.currentBaseNode.getEastNorth()));
        }
        this.snapHelper.checkAngleSnapping(this.currentMouseEastNorth, d2, d);
    }

    private void showStatusInfo(double d, double d2, double d3, boolean bl) {
        Main.map.statusLine.setAngle(d);
        Main.map.statusLine.activateAnglePanel(bl);
        Main.map.statusLine.setHeading(d2);
        Main.map.statusLine.setDist(d3);
    }

    private void determineCurrentBaseNodeAndPreviousNode(Collection<OsmPrimitive> collection) {
        Node node = null;
        AbstractPrimitive abstractPrimitive = null;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                if (node != null) {
                    return;
                }
                node = (Node)osmPrimitive;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            if (abstractPrimitive != null) {
                return;
            }
            abstractPrimitive = (Way)osmPrimitive;
        }
        this.currentBaseNode = null;
        this.previousNode = null;
        if (node == null) {
            if (abstractPrimitive == null) {
                return;
            }
            if (((Way)abstractPrimitive).isFirstLastNode(this.lastUsedNode)) {
                this.currentBaseNode = this.lastUsedNode;
                if (this.lastUsedNode == ((Way)abstractPrimitive).getNode(((Way)abstractPrimitive).getNodesCount() - 1) && ((Way)abstractPrimitive).getNodesCount() > 1) {
                    this.previousNode = ((Way)abstractPrimitive).getNode(((Way)abstractPrimitive).getNodesCount() - 2);
                }
            }
        } else if (abstractPrimitive == null) {
            this.currentBaseNode = node;
        } else if (!abstractPrimitive.isDeleted()) {
            if (node == ((Way)abstractPrimitive).getNode(0)) {
                this.currentBaseNode = node;
                if (((Way)abstractPrimitive).getNodesCount() > 1) {
                    this.previousNode = ((Way)abstractPrimitive).getNode(1);
                }
            }
            if (node == ((Way)abstractPrimitive).lastNode()) {
                this.currentBaseNode = node;
                if (((Way)abstractPrimitive).getNodesCount() > 1) {
                    this.previousNode = ((Way)abstractPrimitive).getNode(((Way)abstractPrimitive).getNodesCount() - 2);
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        this.snapHelper.noSnapNow();
        boolean bl = this.removeHighlighting();
        if (!bl) {
            Main.map.mapView.repaint();
        }
    }

    public static Way getWayForNode(Node node) {
        Way way = null;
        for (Way way2 : Utils.filteredCollection(node.getReferrers(), Way.class)) {
            if (!way2.isUsable() || way2.getNodesCount() < 1) continue;
            Node node2 = way2.getNode(0);
            Node node3 = way2.getNode(way2.getNodesCount() - 1);
            if (node2 != node && node3 != node || node2 == node3) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    public Node getCurrentBaseNode() {
        return this.currentBaseNode;
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> collection, Node node) {
        double d;
        EastNorth eastNorth;
        EastNorth eastNorth2;
        Pair<Node, Node> pair;
        switch (collection.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> iterator = collection.iterator();
                pair = iterator.next();
                eastNorth2 = ((Node)pair.a).getEastNorth();
                eastNorth = ((Node)pair.b).getEastNorth();
                pair = iterator.next();
                EastNorth eastNorth3 = ((Node)pair.a).getEastNorth();
                EastNorth eastNorth4 = ((Node)pair.b).getEastNorth();
                double d2 = DrawAction.det(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north(), eastNorth3.east() - eastNorth4.east(), eastNorth3.north() - eastNorth4.north());
                if (d2 == 0.0) {
                    return;
                }
                d = DrawAction.det(eastNorth.north() - eastNorth3.north(), eastNorth.east() - eastNorth3.east(), eastNorth4.north() - eastNorth3.north(), eastNorth4.east() - eastNorth3.east()) / d2;
                EastNorth eastNorth5 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
                int n = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(node).distance(Main.map.mapView.getPoint(eastNorth5)) < (double)n)) break;
                node.setEastNorth(eastNorth5);
                return;
            }
        }
        EastNorth eastNorth6 = node.getEastNorth();
        pair = collection.iterator().next();
        eastNorth2 = ((Node)pair.a).getEastNorth();
        eastNorth = ((Node)pair.b).getEastNorth();
        double d3 = eastNorth6.distanceSq(eastNorth);
        double d4 = eastNorth6.distanceSq(eastNorth2);
        double d5 = eastNorth2.distanceSq(eastNorth);
        d = (d3 - d4 + d5) / (2.0 * d5);
        node.setEastNorth(new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north())));
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    private void tryToMoveNodeOnIntersection(List<WaySegment> list, Node node) {
        EastNorth eastNorth;
        if (list.isEmpty()) {
            return;
        }
        WaySegment waySegment = list.get(0);
        EastNorth eastNorth2 = waySegment.getFirstNode().getEastNorth();
        EastNorth eastNorth3 = waySegment.getSecondNode().getEastNorth();
        if (this.snapHelper.dir2 != null && this.currentBaseNode != null && (eastNorth = Geometry.getSegmentSegmentIntersection(eastNorth2, eastNorth3, this.snapHelper.dir2, this.currentBaseNode.getEastNorth())) != null) {
            node.setEastNorth(eastNorth);
        }
    }

    private void addHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        if (this.ctrl) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingNode == null && DrawAction.getCurrentDataSet().getSelected().size() == 0 && this.mousePos != null) {
            this.mouseOnExistingNode = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (this.mouseOnExistingNode != null) {
            Main.map.mapView.setNewCursor(this.cursorJoinNode, (Object)this);
            this.newHighlights.add(this.mouseOnExistingNode);
            this.redrawIfRequired();
            return;
        }
        if (this.mouseOnExistingWays.size() == 0) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            this.redrawIfRequired();
            return;
        }
        Main.map.mapView.setNewCursor(this.cursorJoinWay, (Object)this);
        this.newHighlights.addAll(this.mouseOnExistingWays);
        this.redrawIfRequired();
    }

    private boolean removeHighlighting() {
        this.newHighlights = new HashSet<OsmPrimitive>();
        return this.redrawIfRequired();
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (Main.map.mapView == null || this.mousePos == null || this.currentBaseNode == null || this.currentMouseEastNorth == null || !Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D;
        this.snapHelper.drawIfNeeded(graphics2D2, mapView);
        if (!this.drawHelperLine || this.wayIsFinished || this.shift) {
            return;
        }
        if (!this.snapHelper.isActive()) {
            graphics2D2.setColor(this.selectedColor);
            graphics2D2.setStroke(new BasicStroke(3.0f, 1, 1));
        } else if (!this.snapHelper.drawConstructionGeometry) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        Point point = mapView.getPoint(this.currentBaseNode);
        Point point2 = mapView.getPoint(this.currentMouseEastNorth);
        double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
        generalPath.moveTo(point.x, point.y);
        generalPath.lineTo(point2.x, point2.y);
        if (this.alt) {
            generalPath.moveTo((int)((double)point.x + 8.0 * Math.cos(d + this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d + this.PHI)));
            generalPath.lineTo((int)((double)point.x + 8.0 * Math.cos(d - this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d - this.PHI)));
        }
        graphics2D2.draw(generalPath);
        graphics2D2.setStroke(new BasicStroke(1.0f));
    }

    @Override
    public String getModeHelpText() {
        OsmPrimitive osmPrimitive;
        String string = "";
        string = this.ctrl || this.oldHighlights.isEmpty() ? I18n.tr("Create new node.", new Object[0]) : ((osmPrimitive = this.oldHighlights.iterator().next()) instanceof Node ? I18n.tr("Select node under cursor.", new Object[0]) : I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size()));
        if (this.currentBaseNode != null && !this.wayIsFinished) {
            string = this.alt ? string + " " + I18n.tr("Start new way from last node.", new Object[0]) : string + " " + I18n.tr("Continue way from last node.", new Object[0]);
            if (this.snapHelper.isSnapOn()) {
                string = string + " " + I18n.tr("Angle snapping active.", new Object[0]);
            }
        }
        if ((osmPrimitive = this.mouseOnExistingNode) != null && DrawAction.getCurrentDataSet() != null && DrawAction.getCurrentDataSet().getSelectedNodes().contains(osmPrimitive)) {
            string = this.wayIsFinished ? I18n.tr("Select node under cursor.", new Object[0]) : I18n.tr("Finish drawing.", new Object[0]);
        }
        if (DrawAction.getCurrentDataSet() != null && DrawAction.getCurrentDataSet().getSelectedWays().size() > 0 && !this.wayIsFinished && !this.alt) {
            Way way = DrawAction.getCurrentDataSet().getSelectedWays().iterator().next();
            for (Node node : way.getNodes()) {
                if (!node.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(way)) continue;
                string = string + " " + I18n.tr("Finish drawing.", new Object[0]);
                break;
            }
        }
        return string;
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(DrawAction.getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private class SnapChangeAction
    extends JosmAction {
        public SnapChangeAction() {
            super(I18n.tr("Angle snapping", new Object[0]), "anglesnap", I18n.tr("Switch angle snapping mode while drawing", new Object[0]), null, false);
            this.putValue("help", HelpUtil.ht("/Action/Draw/AngleSnap"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DrawAction.this.snapHelper != null) {
                DrawAction.this.snapHelper.toggleSnapping();
            }
        }
    }

    private class SnapHelper {
        boolean snapOn;
        private boolean active;
        private boolean fixed;
        private boolean absoluteFix;
        private boolean drawConstructionGeometry;
        private boolean showProjectedPoint;
        private boolean showAngle;
        private boolean snapToProjections;
        EastNorth dir2;
        EastNorth projected;
        String labelText;
        double lastAngle;
        double customBaseHeading = -1.0;
        private EastNorth segmentPoint1;
        private EastNorth segmentPoint2;
        private EastNorth projectionSource;
        double[] snapAngles;
        double snapAngleTolerance;
        double pe;
        double pn;
        double e0;
        double n0;
        final String fixFmt = "%d " + I18n.tr("FIX", new Object[0]);
        Color snapHelperColor;
        private Color highlightColor;
        private Stroke normalStroke;
        private Stroke helperStroke;
        private Stroke highlightStroke;
        JCheckBoxMenuItem checkBox;
        MouseListener anglePopupListener = new PopupMenuLauncher(new JPopupMenu(){
            JCheckBoxMenuItem helperCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Show helper geometry", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                    Main.pref.put("draw.anglesnap.drawConstructionGeometry", bl);
                    Main.pref.put("draw.anglesnap.drawProjectedPoint", bl);
                    Main.pref.put("draw.anglesnap.showAngle", bl);
                    SnapHelper.this.init();
                    SnapHelper.this.enableSnapping();
                }
            });
            JCheckBoxMenuItem projectionCb = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Snap to node projections", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
                    Main.pref.put("draw.anglesnap.projectionsnap", bl);
                    SnapHelper.this.init();
                    SnapHelper.this.enableSnapping();
                }
            });
            {
                this.helperCb.setState(Main.pref.getBoolean("draw.anglesnap.drawConstructionGeometry", true));
                this.projectionCb.setState(Main.pref.getBoolean("draw.anglesnap.projectionsnapgvff", true));
                this.add(this.helperCb);
                this.add(this.projectionCb);
                this.add(new AbstractAction(I18n.tr("Disable", new Object[0])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SnapHelper.this.saveAngles("180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,90,...", new Object[0])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SnapHelper.this.saveAngles("0", "90", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,45,90,...", new Object[0])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SnapHelper.this.saveAngles("0", "45", "90", "135", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
                this.add(new AbstractAction(I18n.tr("0,30,45,60,90,...", new Object[0])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SnapHelper.this.saveAngles("0", "30", "45", "60", "90", "120", "135", "150", "180");
                        SnapHelper.this.init();
                        SnapHelper.this.enableSnapping();
                    }
                });
            }
        }){

            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getButton() == 1) {
                    SnapHelper.this.toggleSnapping();
                    DrawAction.this.updateStatusLine();
                }
            }
        };

        private SnapHelper() {
        }

        public void init() {
            this.snapOn = false;
            this.checkBox.setState(this.snapOn);
            this.fixed = false;
            this.absoluteFix = false;
            Collection<String> collection = Main.pref.getCollection("draw.anglesnap.angles", Arrays.asList("0", "30", "45", "60", "90", "120", "135", "150", "180"));
            this.snapAngles = new double[2 * collection.size()];
            int n = 0;
            for (String string : collection) {
                try {
                    this.snapAngles[n] = Double.parseDouble(string);
                    this.snapAngles[++n] = 360.0 - Double.parseDouble(string);
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning: incorrect number in draw.anglesnap.angles preferences: " + string);
                    this.snapAngles[n] = 0.0;
                    this.snapAngles[++n] = 0.0;
                    ++n;
                }
            }
            this.snapAngleTolerance = Main.pref.getDouble("draw.anglesnap.tolerance", 5.0);
            this.drawConstructionGeometry = Main.pref.getBoolean("draw.anglesnap.drawConstructionGeometry", true);
            this.showProjectedPoint = Main.pref.getBoolean("draw.anglesnap.drawProjectedPoint", true);
            this.snapToProjections = Main.pref.getBoolean("draw.anglesnap.projectionsnap", true);
            this.showAngle = Main.pref.getBoolean("draw.anglesnap.showAngle", true);
            this.normalStroke = new BasicStroke(3.0f, 1, 1);
            this.snapHelperColor = Main.pref.getColor(I18n.marktr("draw angle snap"), Color.ORANGE);
            this.highlightColor = Main.pref.getColor(I18n.marktr("draw angle snap highlight"), new Color(Color.ORANGE.getRed(), Color.ORANGE.getGreen(), Color.ORANGE.getBlue(), 128));
            this.highlightStroke = new BasicStroke(10.0f, 1, 1);
            Object object = new float[]{4.0f};
            this.helperStroke = new BasicStroke(1.0f, 0, 0, 10.0f, (float[])object, 0.0f);
        }

        public void saveAngles(String ... stringArray) {
            Main.pref.putCollection("draw.anglesnap.angles", Arrays.asList(stringArray));
        }

        public void setMenuCheckBox(JCheckBoxMenuItem jCheckBoxMenuItem) {
            this.checkBox = jCheckBoxMenuItem;
        }

        public void drawIfNeeded(Graphics2D graphics2D, MapView mapView) {
            Point point;
            GeneralPath generalPath;
            if (!this.snapOn || !this.active) {
                return;
            }
            Point point2 = mapView.getPoint(DrawAction.this.currentBaseNode);
            Point point3 = mapView.getPoint(this.dir2);
            Point point4 = mapView.getPoint(this.projected);
            if (this.drawConstructionGeometry) {
                graphics2D.setColor(this.snapHelperColor);
                graphics2D.setStroke(this.helperStroke);
                generalPath = new GeneralPath();
                if (this.absoluteFix) {
                    generalPath.moveTo(point3.x, point3.y);
                    generalPath.lineTo(2 * point2.x - point3.x, 2 * point2.y - point3.y);
                } else {
                    generalPath.moveTo(point3.x, point3.y);
                    generalPath.lineTo(point4.x, point4.y);
                }
                graphics2D.draw(generalPath);
            }
            if (this.projectionSource != null) {
                graphics2D.setColor(this.snapHelperColor);
                graphics2D.setStroke(this.helperStroke);
                generalPath = new GeneralPath();
                generalPath.moveTo(point4.x, point4.y);
                point = mapView.getPoint(this.projectionSource);
                generalPath.lineTo(point.x, point.y);
                graphics2D.draw(generalPath);
            }
            if (this.customBaseHeading >= 0.0) {
                graphics2D.setColor(this.highlightColor);
                graphics2D.setStroke(this.highlightStroke);
                generalPath = new GeneralPath();
                point = mapView.getPoint(this.segmentPoint1);
                Point point5 = mapView.getPoint(this.segmentPoint2);
                generalPath.moveTo(point.x, point.y);
                generalPath.lineTo(point5.x, point5.y);
                graphics2D.draw(generalPath);
            }
            graphics2D.setColor(DrawAction.this.selectedColor);
            graphics2D.setStroke(this.normalStroke);
            generalPath = new GeneralPath();
            generalPath.moveTo(point2.x, point2.y);
            generalPath.lineTo(point4.x, point4.y);
            graphics2D.draw(generalPath);
            graphics2D.drawString(this.labelText, point4.x - 5, point4.y + 20);
            if (this.showProjectedPoint) {
                graphics2D.setStroke(this.normalStroke);
                graphics2D.drawOval(point4.x - 5, point4.y - 5, 10, 10);
            }
            graphics2D.setColor(this.snapHelperColor);
            graphics2D.setStroke(this.helperStroke);
        }

        public void checkAngleSnapping(EastNorth eastNorth, double d, double d2) {
            double d3;
            EastNorth eastNorth2 = DrawAction.this.currentBaseNode.getEastNorth();
            EastNorth eastNorth3 = eastNorth;
            double d4 = -1.0;
            double d5 = d3 = this.customBaseHeading >= 0.0 ? this.customBaseHeading : d;
            if (this.snapOn && d3 >= 0.0) {
                double d6;
                d4 = d2 - d3;
                if (d4 < 0.0) {
                    d4 += 360.0;
                }
                if (d4 > 360.0) {
                    d4 = 0.0;
                }
                if (this.fixed) {
                    d6 = this.lastAngle;
                    this.active = true;
                } else {
                    d6 = this.getNearestAngle(d4);
                    if (this.getAngleDelta(d6, d4) < this.snapAngleTolerance) {
                        this.active = this.customBaseHeading >= 0.0 ? true : Math.abs(d6 - 180.0) > 0.001;
                        this.lastAngle = d6;
                    } else {
                        this.active = false;
                    }
                }
                if (this.active) {
                    this.e0 = eastNorth2.east();
                    this.n0 = eastNorth2.north();
                    this.buildLabelText(d6);
                    double d7 = (d6 + d3) * Math.PI / 180.0;
                    this.pe = Math.sin(d7);
                    this.pn = Math.cos(d7);
                    double d8 = 20.0 * Main.map.mapView.getDist100Pixel();
                    this.dir2 = new EastNorth(this.e0 + d8 * this.pe, this.n0 + d8 * this.pn);
                    eastNorth3 = this.getSnapPoint(eastNorth);
                } else {
                    this.noSnapNow();
                }
            }
            LatLon latLon = Main.map.mapView.getProjection().eastNorth2latlon(eastNorth3);
            double d9 = DrawAction.this.currentBaseNode.getCoor().greatCircleDistance(latLon);
            double d10 = Math.toDegrees(eastNorth2.heading(eastNorth3));
            if (d >= 0.0) {
                d4 = d10 - d;
                if (d4 < 0.0) {
                    d4 += 360.0;
                }
                if (d4 > 360.0) {
                    d4 = 0.0;
                }
            }
            DrawAction.this.showStatusInfo(d4, d10, d9, this.isSnapOn());
        }

        private void buildLabelText(double d) {
            this.labelText = this.showAngle ? (this.fixed ? (this.absoluteFix ? "=" : String.format(this.fixFmt, (int)d)) : String.format("%d", (int)d)) : (this.fixed ? (this.absoluteFix ? "=" : String.format(I18n.tr("FIX", new Object[0]), 0)) : "");
        }

        public EastNorth getSnapPoint(EastNorth eastNorth) {
            DataSet dataSet;
            Collection<Way> collection;
            if (!this.active) {
                return eastNorth;
            }
            double d = eastNorth.east() - this.e0;
            double d2 = eastNorth.north() - this.n0;
            double d3 = d * this.pe + d2 * this.pn;
            double d4 = Main.map.mapView.getDist100Pixel() / 20.0;
            if (!this.absoluteFix && d3 < d4) {
                this.active = false;
                return eastNorth;
            }
            this.projectionSource = null;
            if (this.snapToProjections && (collection = (dataSet = DrawAction.getCurrentDataSet()).getSelectedWays()).size() == 1) {
                Way way = collection.iterator().next();
                ArrayList<EastNorth> arrayList = new ArrayList<EastNorth>();
                if (way.getNodesCount() < 1000) {
                    for (Node node : way.getNodes()) {
                        arrayList.add(node.getEastNorth());
                    }
                }
                if (this.customBaseHeading >= 0.0) {
                    arrayList.add(this.segmentPoint1);
                    arrayList.add(this.segmentPoint2);
                }
                Object object = null;
                double d5 = 100000.0;
                for (EastNorth eastNorth2 : arrayList) {
                    double d6 = (eastNorth2.east() - this.e0) * this.pe + (eastNorth2.north() - this.n0) * this.pn;
                    double d7 = Math.abs(d6 - d3);
                    if (!(d7 < d4) || !(d7 < d5)) continue;
                    d3 = d6;
                    object = eastNorth2;
                    d5 = d7;
                }
                if (object != null) {
                    this.projectionSource = object;
                }
            }
            this.projected = new EastNorth(this.e0 + d3 * this.pe, this.n0 + d3 * this.pn);
            return this.projected;
        }

        public void noSnapNow() {
            this.active = false;
            this.dir2 = null;
            this.projected = null;
            this.labelText = null;
        }

        public void setBaseSegment(WaySegment waySegment) {
            if (waySegment == null) {
                return;
            }
            this.segmentPoint1 = waySegment.getFirstNode().getEastNorth();
            this.segmentPoint2 = waySegment.getSecondNode().getEastNorth();
            double d = this.segmentPoint1.heading(this.segmentPoint2);
            if ((d = Math.toDegrees(d)) < 0.0) {
                d += 360.0;
            }
            if (d > 360.0) {
                d -= 360.0;
            }
            this.customBaseHeading = d;
        }

        private void nextSnapMode() {
            if (this.snapOn) {
                if (this.fixed || !this.active) {
                    this.snapOn = false;
                    this.unsetFixedMode();
                } else {
                    this.setFixedMode();
                }
            } else {
                this.snapOn = true;
                this.unsetFixedMode();
            }
            this.checkBox.setState(this.snapOn);
            this.customBaseHeading = -1.0;
        }

        private void enableSnapping() {
            this.snapOn = true;
            this.checkBox.setState(this.snapOn);
            this.customBaseHeading = -1.0;
            this.unsetFixedMode();
        }

        private void toggleSnapping() {
            this.snapOn = !this.snapOn;
            this.checkBox.setState(this.snapOn);
            this.customBaseHeading = -1.0;
            this.unsetFixedMode();
        }

        public void setFixedMode() {
            if (this.active) {
                this.fixed = true;
            }
        }

        public void unsetFixedMode() {
            this.fixed = false;
            this.absoluteFix = false;
            this.lastAngle = 0.0;
            this.active = false;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isSnapOn() {
            return this.snapOn;
        }

        private double getNearestAngle(double d) {
            double d2 = 100000.0;
            double d3 = 0.0;
            for (int i = 0; i < this.snapAngles.length; ++i) {
                double d4 = this.getAngleDelta(d, this.snapAngles[i]);
                if (!(d4 < d2)) continue;
                d2 = d4;
                d3 = this.snapAngles[i];
            }
            if (Math.abs(d3 - 360.0) < 0.001) {
                d3 = 0.0;
            }
            return d3;
        }

        private double getAngleDelta(double d, double d2) {
            double d3 = Math.abs(d - d2);
            if (d3 > 180.0) {
                return 360.0 - d3;
            }
            return d3;
        }

        private void unFixOrTurnOff() {
            if (this.absoluteFix) {
                this.unsetFixedMode();
            } else {
                this.toggleSnapping();
            }
        }
    }

    public class BackSpaceAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.undoRedo.undo();
            Node node = null;
            Command command = Main.main.undoRedo.commands.peekLast();
            if (command == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : command.getParticipatingPrimitives()) {
                if (!(osmPrimitive instanceof Node)) continue;
                if (node == null) {
                    node = (Node)osmPrimitive;
                    DrawAction.this.wayIsFinished = false;
                    continue;
                }
                node = null;
                break;
            }
            if (node != null) {
                DrawAction.getCurrentDataSet().addSelected(node);
            }
        }
    }
}

