/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class ContextSwitchTemplate
implements TemplateEntry {
    private static final TemplateEngineDataProvider EMTPY_PROVIDER = new TemplateEngineDataProvider(){

        @Override
        public Object getTemplateValue(String string, boolean bl) {
            return null;
        }

        @Override
        public Collection<String> getTemplateKeys() {
            return Collections.emptyList();
        }

        @Override
        public boolean evaluateCondition(SearchCompiler.Match match) {
            return false;
        }
    };
    private final ContextProvider context;
    private final TemplateEntry template;

    private SearchCompiler.Match transform(SearchCompiler.Match match, int n) throws ParseError {
        if (match instanceof SearchCompiler.Parent) {
            SearchCompiler.Match match2 = this.transform(((SearchCompiler.Parent)match).getOperand(), n);
            return new ParentSet(match2);
        }
        if (match instanceof SearchCompiler.Child) {
            SearchCompiler.Match match3 = this.transform(((SearchCompiler.Child)match).getOperand(), n);
            return new ChildSet(match3);
        }
        if (match instanceof SearchCompiler.And) {
            SearchCompiler.Match match4 = this.transform(((SearchCompiler.And)match).getLhs(), n);
            SearchCompiler.Match match5 = this.transform(((SearchCompiler.And)match).getRhs(), n);
            if (match4 instanceof ContextProvider && match5 instanceof ContextProvider) {
                return new AndSet((ContextProvider)match4, (ContextProvider)match5);
            }
            if (match4 instanceof ContextProvider) {
                ContextProvider contextProvider = (ContextProvider)match4;
                contextProvider.condition = contextProvider.condition == null ? match5 : new SearchCompiler.And(contextProvider.condition, match5);
                return contextProvider;
            }
            if (match5 instanceof ContextProvider) {
                ContextProvider contextProvider = (ContextProvider)match5;
                contextProvider.condition = contextProvider.condition == null ? match4 : new SearchCompiler.And(match4, contextProvider.condition);
                return contextProvider;
            }
            return match;
        }
        if (match instanceof SearchCompiler.Or) {
            SearchCompiler.Match match6 = this.transform(((SearchCompiler.Or)match).getLhs(), n);
            SearchCompiler.Match match7 = this.transform(((SearchCompiler.Or)match).getRhs(), n);
            if (match6 instanceof ContextProvider && match7 instanceof ContextProvider) {
                return new OrSet((ContextProvider)match6, (ContextProvider)match7);
            }
            if (match6 instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - right side of or(|) expression must return set of primitives", n));
            }
            if (match7 instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - left side of or(|) expression must return set of primitives", n));
            }
            return match;
        }
        if (match instanceof SearchCompiler.Not) {
            SearchCompiler.Match match8 = this.transform(((SearchCompiler.Not)match).getMatch(), n);
            if (match8 instanceof ContextProvider) {
                throw new ParseError(I18n.tr("Error in search expression on position {0} - not(-) cannot be used in this context", n));
            }
            return match;
        }
        return match;
    }

    public ContextSwitchTemplate(SearchCompiler.Match match, TemplateEntry templateEntry, int n) throws ParseError {
        SearchCompiler.Match match2 = this.transform(match, n);
        if (!(match2 instanceof ContextProvider)) {
            throw new ParseError(I18n.tr("Error in search expression on position {0} - expression must return different then current primitive", n));
        }
        this.context = (ContextProvider)match2;
        this.template = templateEntry;
    }

    public void appendText(StringBuilder stringBuilder, TemplateEngineDataProvider templateEngineDataProvider) {
        List<OsmPrimitive> list = this.context.getPrimitives((OsmPrimitive)templateEngineDataProvider);
        if (list != null && !list.isEmpty()) {
            this.template.appendText(stringBuilder, list.get(0));
        } else {
            this.template.appendText(stringBuilder, EMTPY_PROVIDER);
        }
    }

    public boolean isValid(TemplateEngineDataProvider templateEngineDataProvider) {
        List<OsmPrimitive> list = this.context.getPrimitives((OsmPrimitive)templateEngineDataProvider);
        if (list != null && !list.isEmpty()) {
            return this.template.isValid(list.get(0));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AndSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        AndSet(ContextProvider contextProvider, ContextProvider contextProvider2) {
            this.lhs = contextProvider;
            this.rhs = contextProvider2;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive osmPrimitive) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            List<OsmPrimitive> list = this.lhs.getPrimitives(osmPrimitive);
            for (OsmPrimitive osmPrimitive2 : this.rhs.getPrimitives(osmPrimitive)) {
                if (!list.contains(osmPrimitive2) || this.condition != null && !this.condition.match(osmPrimitive2)) continue;
                arrayList.add(osmPrimitive2);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrSet
    extends ContextProvider {
        private final ContextProvider lhs;
        private final ContextProvider rhs;

        OrSet(ContextProvider contextProvider, ContextProvider contextProvider2) {
            this.lhs = contextProvider;
            this.rhs = contextProvider2;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive osmPrimitive) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive2 : this.lhs.getPrimitives(osmPrimitive)) {
                if (this.condition != null && !this.condition.match(osmPrimitive2)) continue;
                arrayList.add(osmPrimitive2);
            }
            for (OsmPrimitive osmPrimitive2 : this.rhs.getPrimitives(osmPrimitive)) {
                if (this.condition != null && (!this.condition.match(osmPrimitive2) || arrayList.contains(osmPrimitive2))) continue;
                arrayList.add(osmPrimitive2);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildSet
    extends ContextProvider {
        private final SearchCompiler.Match parentCondition;

        ChildSet(SearchCompiler.Match match) {
            this.parentCondition = match;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive osmPrimitive) {
            List<OsmPrimitive> list = this.parentCondition instanceof ContextProvider ? ((ContextProvider)this.parentCondition).getPrimitives(osmPrimitive) : (this.parentCondition.match(osmPrimitive) ? Collections.singletonList(osmPrimitive) : Collections.emptyList());
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive2 : list) {
                if (osmPrimitive2 instanceof Way) {
                    for (Node node : ((Way)osmPrimitive2).getNodes()) {
                        if (this.condition != null && this.condition.match(node)) {
                            arrayList.add(node);
                        }
                        arrayList.add(node);
                    }
                    continue;
                }
                if (!(osmPrimitive2 instanceof Relation)) continue;
                for (RelationMember relationMember : ((Relation)osmPrimitive2).getMembers()) {
                    if (this.condition == null || !this.condition.match(relationMember.getMember())) continue;
                    arrayList.add(relationMember.getMember());
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentSet
    extends ContextProvider {
        private final SearchCompiler.Match childCondition;

        ParentSet(SearchCompiler.Match match) {
            this.childCondition = match;
        }

        @Override
        public boolean match(OsmPrimitive osmPrimitive) {
            throw new UnsupportedOperationException();
        }

        @Override
        List<OsmPrimitive> getPrimitives(OsmPrimitive osmPrimitive) {
            List<OsmPrimitive> list = this.childCondition instanceof ContextProvider ? ((ContextProvider)this.childCondition).getPrimitives(osmPrimitive) : (this.childCondition.match(osmPrimitive) ? Collections.singletonList(osmPrimitive) : Collections.emptyList());
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive2 : list) {
                for (OsmPrimitive osmPrimitive3 : osmPrimitive2.getReferrers(true)) {
                    if (this.condition != null && !this.condition.match(osmPrimitive3)) continue;
                    arrayList.add(osmPrimitive3);
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ContextProvider
    extends SearchCompiler.Match {
        SearchCompiler.Match condition;

        private ContextProvider() {
        }

        abstract List<OsmPrimitive> getPrimitives(OsmPrimitive var1);
    }
}

