/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlObjectParser
implements Iterable<Object> {
    public static final String lang = LanguageInfo.getLanguageCodeXML();
    private Map<String, Entry> mapping = new HashMap<String, Entry>();
    private DefaultHandler parser;
    private LinkedList<Object> queue = new LinkedList();
    private Iterator<Object> queueIterator = null;

    public XmlObjectParser() {
        this.parser = new Parser();
    }

    public XmlObjectParser(DefaultHandler defaultHandler) {
        this.parser = defaultHandler;
    }

    private Iterable<Object> start(Reader reader, ContentHandler contentHandler) throws SAXException, IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            xMLReader.parse(new InputSource(reader));
            this.queueIterator = this.queue.iterator();
            return this;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    public Iterable<Object> start(Reader reader) throws SAXException {
        try {
            return this.start(reader, this.parser);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public Iterable<Object> startWithValidation(Reader reader, String string, String string2) throws SAXException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new StreamSource(new MirroredInputStream(string2)));
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            validatorHandler.setContentHandler(this.parser);
            validatorHandler.setErrorHandler(this.parser);
            AddNamespaceFilter addNamespaceFilter = new AddNamespaceFilter(string);
            addNamespaceFilter.setContentHandler(validatorHandler);
            return this.start(reader, addNamespaceFilter);
        }
        catch (IOException iOException) {
            throw new SAXException(I18n.tr("Failed to load XML schema.", new Object[0]), iOException);
        }
    }

    public void map(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, false));
    }

    public void mapOnStart(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, true, false));
    }

    public void mapBoth(String string, Class<?> clazz) {
        this.mapping.put(string, new Entry(clazz, false, true));
    }

    public Object next() {
        return this.queueIterator.next();
    }

    public boolean hasNext() {
        return this.queueIterator.hasNext();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.queue.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        Class<?> klass;
        boolean onStart;
        boolean both;

        public Entry(Class<?> clazz, boolean bl, boolean bl2) {
            this.klass = clazz;
            this.onStart = bl;
            this.both = bl2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Parser
    extends DefaultHandler {
        Stack<Object> current = new Stack();
        StringBuilder characters = new StringBuilder(64);
        private Locator locator;

        private Parser() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(Exception exception) throws PresetParsingException {
            throw new PresetParsingException(exception).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3)) {
                Class<?> clazz = ((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).klass;
                try {
                    this.current.push(clazz.newInstance());
                }
                catch (Exception exception) {
                    this.throwException(exception);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.setValue(attributes.getQName(i), attributes.getValue(i));
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).onStart) {
                    this.report();
                }
                if (((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).both) {
                    XmlObjectParser.this.queue.add(this.current.peek());
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XmlObjectParser.this.mapping.containsKey(string3) && !((Entry)((XmlObjectParser)XmlObjectParser.this).mapping.get((Object)string3)).onStart) {
                this.report();
            } else if (this.characters != null && !this.current.isEmpty()) {
                this.setValue(string3, this.characters.toString().trim());
                this.characters = new StringBuilder(64);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.characters.append(cArray, n, n2);
        }

        private void report() {
            XmlObjectParser.this.queue.add(this.current.pop());
            this.characters = new StringBuilder(64);
        }

        private Object getValueForClass(Class<?> clazz, String string) {
            if (clazz == Boolean.TYPE) {
                return this.parseBoolean(string);
            }
            if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE) {
                return Double.parseDouble(string);
            }
            return string;
        }

        private void setValue(String string, String string2) throws SAXException {
            if (string.equals("class") || string.equals("default") || string.equals("throw") || string.equals("new") || string.equals("null")) {
                string = string + "_";
            }
            try {
                Field field;
                Object object;
                block12: {
                    object = this.current.peek();
                    field = null;
                    try {
                        field = object.getClass().getField(string);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (!string.startsWith(lang)) break block12;
                        Method[] methodArray = "locale_" + string.substring(lang.length());
                        try {
                            field = object.getClass().getField((String)methodArray);
                        }
                        catch (NoSuchFieldException noSuchFieldException2) {
                            // empty catch block
                        }
                    }
                }
                if (field != null && Modifier.isPublic(field.getModifiers())) {
                    field.set(object, this.getValueForClass(field.getType(), string2));
                } else {
                    Method[] methodArray;
                    if (string.startsWith(lang)) {
                        int n = lang.length();
                        string = "set" + string.substring(n, n + 1).toUpperCase() + string.substring(n + 1);
                    } else {
                        string = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
                    }
                    for (Method method : methodArray = object.getClass().getDeclaredMethods()) {
                        if (!method.getName().equals(string) || method.getParameterTypes().length != 1) continue;
                        method.invoke(object, this.getValueForClass(method.getParameterTypes()[0], string2));
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.throwException(exception);
            }
        }

        private boolean parseBoolean(String string) {
            return string != null && !string.equals("0") && !string.startsWith("off") && !string.startsWith("false") && !string.startsWith("no");
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }

    private static class AddNamespaceFilter
    extends XMLFilterImpl {
        private final String namespace;

        public AddNamespaceFilter(String string) {
            this.namespace = string;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("".equals(string)) {
                super.startElement(this.namespace, string2, string3, attributes);
            } else {
                super.startElement(string, string2, string3, attributes);
            }
        }
    }

    public static class PresetParsingException
    extends SAXException {
        private int columnNumber;
        private int lineNumber;

        public PresetParsingException() {
        }

        public PresetParsingException(Exception exception) {
            super(exception);
        }

        public PresetParsingException(String string, Exception exception) {
            super(string, exception);
        }

        public PresetParsingException(String string) {
            super(string);
        }

        public PresetParsingException rememberLocation(Locator locator) {
            if (locator == null) {
                return this;
            }
            this.columnNumber = locator.getColumnNumber();
            this.lineNumber = locator.getLineNumber();
            return this;
        }

        public String getMessage() {
            String string = super.getMessage();
            if (this.lineNumber == 0 && this.columnNumber == 0) {
                return string;
            }
            if (string == null) {
                string = this.getClass().getName();
            }
            string = string + " " + I18n.tr("(at line {0}, column {1})", this.lineNumber, this.columnNumber);
            return string;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

