/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Utils;

public class UrlLabel
extends JEditorPane
implements HyperlinkListener,
MouseListener {
    private String url = "";
    private String description = "";

    public UrlLabel() {
        this.addHyperlinkListener(this);
        this.addMouseListener(this);
        this.setEditable(false);
        this.setOpaque(false);
    }

    public UrlLabel(String string) {
        this(string, string);
    }

    public UrlLabel(String string, String string2) {
        this();
        this.setUrl(string);
        this.setDescription(string2);
        this.refresh();
    }

    protected void refresh() {
        this.setContentType("text/html");
        if (this.url != null) {
            this.setText("<html><a href=\"" + this.url + "\">" + this.description + "</a></html>");
        } else {
            this.setText("<html>" + this.description + "</html>");
        }
        this.setToolTipText(String.format("<html>%s<br/>%s</html>", this.url, I18n.tr("Right click = copy to clipboard", new Object[0])));
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenBrowser.displayUrl(this.url);
        }
    }

    public void setUrl(String string) {
        this.url = string;
        this.refresh();
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
        this.description = this.description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
        this.refresh();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            Utils.copyToClipboard(this.url);
        }
    }
}

