/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNodeHandler
extends RequestHandler {
    public static final String command = "add_node";
    public static final String permissionKey = "remotecontrol.permission.create-objects";
    public static final boolean permissionDefault = false;

    @Override
    protected void handleRequest() {
        this.addNode(this.args);
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"lat", "lon"};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to create a new node.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(permissionKey, false, "RemoteControl: creating objects forbidden by preferences");
    }

    private void addNode(HashMap<String, String> hashMap) {
        double d = Double.parseDouble(hashMap.get("lat"));
        double d2 = Double.parseDouble(hashMap.get("lon"));
        System.out.println("Adding node at (" + d + ", " + d2 + ")");
        LatLon latLon = new LatLon(d, d2);
        Node node = new Node(latLon);
        Main.main.undoRedo.add(new AddCommand(node));
        Main.main.getCurrentDataSet().setSelected(node);
        if (Main.pref.getBoolean("remotecontrol.permission.change-viewport", true)) {
            AutoScaleAction.autoScale("selection");
        } else {
            Main.map.mapView.repaint();
        }
    }
}

