/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmChangeBuilder {
    public static final String DEFAULT_API_VERSION = "0.6";
    private String currentMode;
    private PrintWriter writer;
    private StringWriter swriter;
    private OsmWriter osmwriter;
    private String apiVersion = "0.6";
    private boolean prologWritten = false;

    public OsmChangeBuilder(Changeset changeset) {
        this(changeset, null);
    }

    public OsmChangeBuilder(Changeset changeset, String string) {
        this.apiVersion = string == null ? DEFAULT_API_VERSION : string;
        this.swriter = new StringWriter();
        this.writer = new PrintWriter(this.swriter);
        this.osmwriter = OsmWriterFactory.createOsmWriter(this.writer, false, string);
        this.osmwriter.setChangeset(changeset);
    }

    protected void write(IPrimitive iPrimitive) {
        if (iPrimitive.isDeleted()) {
            this.switchMode("delete");
            this.osmwriter.setWithBody(false);
            iPrimitive.visit(this.osmwriter);
        } else {
            this.switchMode(iPrimitive.isNew() ? "create" : "modify");
            this.osmwriter.setWithBody(true);
            iPrimitive.visit(this.osmwriter);
        }
    }

    private void switchMode(String string) {
        if (string != null && !string.equals(this.currentMode) || string == null && this.currentMode != null) {
            if (this.currentMode != null) {
                this.writer.print("</");
                this.writer.print(this.currentMode);
                this.writer.println(">");
            }
            if (string != null) {
                this.writer.print("<");
                this.writer.print(string);
                this.writer.println(">");
            }
            this.currentMode = string;
        }
    }

    public void start() throws IllegalStateException {
        if (this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document already written. Please write only once.", new Object[0]));
        }
        this.writer.print("<osmChange version=\"");
        this.writer.print(this.apiVersion);
        this.writer.println("\" generator=\"JOSM\">");
        this.prologWritten = true;
    }

    public void append(Collection<? extends IPrimitive> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write first.", new Object[0]));
        }
        for (IPrimitive iPrimitive : collection) {
            this.write(iPrimitive);
        }
    }

    public void append(IPrimitive iPrimitive) {
        if (iPrimitive == null) {
            return;
        }
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write first.", new Object[0]));
        }
        this.write(iPrimitive);
    }

    public void finish() throws IllegalStateException {
        if (!this.prologWritten) {
            throw new IllegalStateException(I18n.tr("Prolog of OsmChange document not written yet. Please write first.", new Object[0]));
        }
        if (this.currentMode != null) {
            this.writer.print("</");
            this.writer.print(this.currentMode);
            this.writer.println(">");
        }
        this.writer.println("</osmChange>");
    }

    public String getDocument() {
        return this.swriter.toString();
    }
}

