/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.projection.Projections;

public final class Node
extends OsmPrimitive
implements INode {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double east = Double.NaN;
    private double north = Double.NaN;

    private boolean isLatLonKnown() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    public final void setCoor(LatLon latLon) {
        if (latLon != null) {
            this.updateCoor(latLon, null);
        }
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            this.updateCoor(null, eastNorth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoor(LatLon latLon, EastNorth eastNorth) {
        if (this.getDataSet() != null) {
            boolean bl = this.writeLock();
            try {
                this.getDataSet().fireNodeMoved(this, latLon, eastNorth);
            }
            finally {
                this.writeUnlock(bl);
            }
        } else {
            this.setCoorInternal(latLon, eastNorth);
        }
    }

    public final LatLon getCoor() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        return new LatLon(this.lat, this.lon);
    }

    public final EastNorth getEastNorth() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        if (this.getDataSet() == null) {
            return Projections.project(new LatLon(this.lat, this.lon));
        }
        if (Double.isNaN(this.east) || Double.isNaN(this.north)) {
            EastNorth eastNorth = Projections.project(new LatLon(this.lat, this.lon));
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        }
        return new EastNorth(this.east, this.north);
    }

    protected void setCoorInternal(LatLon latLon, EastNorth eastNorth) {
        if (latLon != null) {
            this.lat = latLon.lat();
            this.lon = latLon.lon();
            this.invalidateEastNorthCache();
        } else if (eastNorth != null) {
            LatLon latLon2 = Projections.inverseProject(eastNorth);
            this.lat = latLon2.lat();
            this.lon = latLon2.lon();
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected Node(long l, boolean bl) {
        super(l, bl);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long l) {
        super(l, false);
    }

    public Node(long l, int n) {
        super(l, n, false);
    }

    public Node(Node node, boolean bl) {
        super(node.getUniqueId(), true);
        this.cloneFrom(node);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Node(Node node) {
        this(node, false);
    }

    public Node(LatLon latLon) {
        super(0L, false);
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        if (!(this.isIncomplete() || this.getCoor() != null && this.getEastNorth() != null)) {
            throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString() + this.get3892DebugInfo());
        }
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void visit(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            this.setCoor(((Node)osmPrimitive).getCoor());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.mergeFrom(osmPrimitive);
            if (!osmPrimitive.isIncomplete()) {
                this.setCoor(((Node)osmPrimitive).getCoor());
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            this.setCoor(((NodeData)primitiveData).getCoor());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public NodeData save() {
        NodeData nodeData = new NodeData();
        this.saveCommonAttributes(nodeData);
        if (!this.isIncomplete()) {
            nodeData.setCoor(this.getCoor());
        }
        return nodeData;
    }

    public String toString() {
        String string = this.isLatLonKnown() ? "lat=" + this.lat + ",lon=" + this.lon : "";
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        LatLon latLon = this.getCoor();
        LatLon latLon2 = node.getCoor();
        if (latLon == null && latLon2 == null) {
            return true;
        }
        if (latLon != null && latLon2 != null) {
            return latLon.equalsEpsilon(latLon2);
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : 1;
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    public BBox getBBox() {
        return new BBox(this);
    }

    public void updatePosition() {
    }

    public boolean isConnectionNode() {
        return this.isReferredByWays(2);
    }

    public String get3892DebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unexpected error. Please report it to http://josm.openstreetmap.de/ticket/3892\n");
        stringBuilder.append(this.toString());
        stringBuilder.append("\n");
        if (this.isLatLonKnown()) {
            stringBuilder.append("Coor is null\n");
        } else {
            stringBuilder.append(String.format("EastNorth: %s\n", this.getEastNorth()));
            stringBuilder.append(Main.getProjection());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }
}

