/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer", new Object[0]), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer", new Object[0]), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge", new Object[0])), 77, 5006), true, "action/mergelayer", true);
        this.putValue("help", HelpUtil.ht("/Action/MergeLayer"));
    }

    public void merge(List<Layer> list) {
        Layer layer = this.askTargetLayer(list);
        if (layer == null) {
            return;
        }
        for (Layer layer2 : list) {
            if (layer2 == layer) continue;
            layer.mergeFrom(layer2);
            Main.map.mapView.removeLayer(layer2);
        }
        Main.map.mapView.setActiveLayer(layer);
    }

    public void merge(final Layer layer) {
        if (layer == null) {
            return;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(layer);
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(layer);
            return;
        }
        final Layer layer2 = this.askTargetLayer(list);
        if (layer2 == null) {
            return;
        }
        Main.worker.submit(new Runnable(){

            public void run() {
                layer2.mergeFrom(layer);
                Main.map.mapView.removeLayer(layer);
                Main.map.mapView.setActiveLayer(layer2);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        this.merge(osmDataLayer);
    }

    @Override
    protected void updateEnabledState() {
        if (MergeLayerAction.getEditLayer() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(MergeLayerAction.getEditLayer()).isEmpty());
    }
}

