/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionReader {
    private static Map<String, Class<? extends SessionLayerImporter>> sessionLayerImporters = new HashMap<String, Class<? extends SessionLayerImporter>>();
    private File sessionFile;
    private boolean zip;
    private ZipFile zipFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private List<Runnable> postLoadTasks = new ArrayList<Runnable>();

    public static void registerSessionLayerImporter(String string, Class<? extends SessionLayerImporter> clazz) {
        sessionLayerImporters.put(string, clazz);
    }

    public static SessionLayerImporter getSessionLayerImporter(String string) {
        Class<? extends SessionLayerImporter> clazz = sessionLayerImporters.get(string);
        if (clazz == null) {
            return null;
        }
        SessionLayerImporter sessionLayerImporter = null;
        try {
            sessionLayerImporter = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return sessionLayerImporter;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public List<Runnable> getPostLoadTasks() {
        return this.postLoadTasks;
    }

    private void error(String string) throws IllegalDataException {
        throw new IllegalDataException(string);
    }

    private void parseJos(Document document, ProgressMonitor progressMonitor) throws IllegalDataException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        NodeList nodeList;
        String string;
        Element element = document.getDocumentElement();
        if (!Utils.equal(element.getTagName(), "josm-session")) {
            this.error(I18n.tr("Unexpected root element ''{0}'' in session file", element.getTagName()));
        }
        if (!"0.1".equals(string = element.getAttribute("version"))) {
            this.error(I18n.tr("Version ''{0}'' of session file is not supported. Expected: 0.1", string));
        }
        if ((nodeList = element.getElementsByTagName("layers")).getLength() == 0) {
            return;
        }
        Element element2 = (Element)nodeList.item(0);
        MultiMap<Serializable, Object> multiMap = new MultiMap<Serializable, Object>();
        HashMap<Serializable, Object> hashMap = new HashMap<Serializable, Object>();
        NodeList nodeList2 = element2.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object4 = nodeList2.item(i);
            if (object4.getNodeType() != 1 || !Utils.equal((object3 = (Element)object4).getTagName(), "layer")) continue;
            if (!object3.hasAttribute("index")) {
                this.error(I18n.tr("missing mandatory attribute ''index'' for element ''layer''", new Object[0]));
            }
            serializable = null;
            try {
                serializable = Integer.valueOf(Integer.parseInt(object3.getAttribute("index")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (serializable == null) {
                this.error(I18n.tr("unexpected format of attribute ''index'' for element ''layer''", new Object[0]));
            }
            if (hashMap.containsKey(serializable)) {
                this.error(I18n.tr("attribute ''index'' ({0}) for element ''layer'' must be unique", Integer.toString((Integer)serializable)));
            }
            hashMap.put(serializable, object3);
            multiMap.putVoid(serializable);
            object2 = object3.getAttribute("depends");
            if (object2 == null) continue;
            for (String string2 : ((String)object2).split(",")) {
                object = null;
                try {
                    object = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (object == null) continue;
                multiMap.put(serializable, object);
            }
        }
        List list = Utils.topologicalSort(multiMap);
        object4 = new TreeMap(Collections.reverseOrder());
        object3 = new HashMap();
        serializable = new HashMap();
        progressMonitor.setTicksCount(list.size());
        object2 = list.iterator();
        block9: while (object2.hasNext()) {
            CancelOrContinueDialog cancelOrContinueDialog;
            Object object5;
            Object object6;
            String string2;
            int n = (Integer)object2.next();
            Element element3 = (Element)hashMap.get(n);
            if (element3 == null) {
                this.error(I18n.tr("missing layer with index {0}", n));
            }
            if (!element3.hasAttribute("name")) {
                this.error(I18n.tr("missing mandatory attribute ''name'' for element ''layer''", new Object[0]));
            }
            String string3 = element3.getAttribute("name");
            serializable.put(n, string3);
            if (!element3.hasAttribute("type")) {
                this.error(I18n.tr("missing mandatory attribute ''type'' for element ''layer''", new Object[0]));
            }
            if ((object = SessionReader.getSessionLayerImporter(string2 = element3.getAttribute("type"))) == null) {
                object6 = new CancelOrContinueDialog();
                ((CancelOrContinueDialog)object6).show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer of type ''{0}'' because no suitable importer was found.", string2), 2, progressMonitor);
                if (!((CancelOrContinueDialog)object6).isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            object3.put(n, object);
            object6 = new LinkedHashMap();
            Object object7 = multiMap.get(Integer.valueOf(n)).iterator();
            while (object7.hasNext()) {
                int n2 = (Integer)object7.next();
                object5 = (SessionLayerImporter)object3.get(n2);
                if (object5 == null) {
                    cancelOrContinueDialog = new CancelOrContinueDialog();
                    cancelOrContinueDialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer {0} because it depends on layer {1} which has been skipped.", n, n2), 2, progressMonitor);
                    if (!cancelOrContinueDialog.isCancel()) continue block9;
                    progressMonitor.cancel();
                    return;
                }
                ((HashMap)object6).put(n2, object5);
            }
            object7 = new ImportSupport(string3, n, (LinkedHashMap<Integer, SessionLayerImporter>)object6);
            Layer layer = null;
            object5 = null;
            try {
                layer = object.load(element3, (ImportSupport)object7, progressMonitor.createSubTaskMonitor(1, false));
            }
            catch (IllegalDataException illegalDataException) {
                object5 = illegalDataException;
            }
            catch (IOException iOException) {
                object5 = iOException;
            }
            if (object5 != null) {
                ((Throwable)object5).printStackTrace();
                cancelOrContinueDialog = new CancelOrContinueDialog();
                cancelOrContinueDialog.show(I18n.tr("Error loading layer", new Object[0]), I18n.tr("<html>Could not load layer {0} ''{1}''.<br>Error is:<br>{2}</html>", n, string3, ((Throwable)object5).getMessage()), 0, progressMonitor);
                if (!cancelOrContinueDialog.isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            if (layer == null) {
                throw new RuntimeException();
            }
            object4.put(n, layer);
            progressMonitor.worked(1);
        }
        this.layers = new ArrayList<Layer>();
        for (Map.Entry entry : object4.entrySet()) {
            Layer layer = (Layer)entry.getValue();
            if (layer == null) continue;
            layer.setName((String)serializable.get(entry.getKey()));
            this.layers.add(layer);
        }
    }

    public void loadSession(File file, boolean bl, ProgressMonitor progressMonitor) throws IllegalDataException, IOException {
        Object object;
        Object object2;
        Object object3;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.sessionFile = file;
        this.zip = bl;
        InputStream inputStream = null;
        if (bl) {
            try {
                this.zipFile = new ZipFile(file);
                object3 = null;
                object2 = this.zipFile.entries();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (!((ZipEntry)object).getName().toLowerCase().endsWith(".jos")) continue;
                    object3 = object;
                    break;
                }
                if (object3 == null) {
                    this.error(I18n.tr("expected .jos file inside .joz archive", new Object[0]));
                }
                inputStream = this.zipFile.getInputStream((ZipEntry)object3);
            }
            catch (ZipException zipException) {
                throw new IOException(zipException);
            }
        }
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException);
        }
        try {
            object3 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object3).setValidating(false);
            ((DocumentBuilderFactory)object3).setNamespaceAware(true);
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse(inputStream);
            this.parseJos((Document)object, progressMonitor);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
    }

    static {
        SessionReader.registerSessionLayerImporter("osm-data", OsmDataSessionImporter.class);
    }

    private static class CancelOrContinueDialog {
        private boolean cancel;

        private CancelOrContinueDialog() {
        }

        public void show(final String string, final String string2, final int n, ProgressMonitor progressMonitor) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Skip layer and continue", new Object[0])});
                        extendedDialog.setButtonIcons(new String[]{"cancel", "dialogs/next"});
                        extendedDialog.setIcon(n);
                        extendedDialog.setContent(string2);
                        extendedDialog.showDialog();
                        CancelOrContinueDialog.this.cancel = extendedDialog.getValue() != 2;
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImportSupport {
        private String layerName;
        private int layerIndex;
        private LinkedHashMap<Integer, SessionLayerImporter> layerDependencies;
        private String inZipPath;

        public ImportSupport(String string, int n, LinkedHashMap<Integer, SessionLayerImporter> linkedHashMap) {
            this.layerName = string;
            this.layerIndex = n;
            this.layerDependencies = linkedHashMap;
        }

        public void addPostLayersTask(Runnable runnable) {
            SessionReader.this.postLoadTasks.add(runnable);
        }

        public InputStream getInputStream(String string) throws IOException {
            ZipEntry zipEntry;
            File file = this.getFile(string);
            if (file != null) {
                try {
                    return new BufferedInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getPath()));
                }
            }
            if (this.inZipPath != null && (zipEntry = SessionReader.this.zipFile.getEntry(this.inZipPath)) != null) {
                InputStream inputStream = SessionReader.this.zipFile.getInputStream(zipEntry);
                return inputStream;
            }
            throw new IOException(I18n.tr("Unable to locate file  ''{0}''.", string));
        }

        public File getFile(String string) throws IOException {
            this.inZipPath = null;
            try {
                URI uRI = new URI(string);
                if ("file".equals(uRI.getScheme())) {
                    return new File(uRI);
                }
                if (uRI.getScheme() == null) {
                    File file = new File(string);
                    if (file.isAbsolute()) {
                        return file;
                    }
                    if (this.isZip()) {
                        if (uRI.getPath().startsWith("../")) {
                            String string2 = uRI.getPath().substring(3);
                            return new File(SessionReader.this.sessionFile.toURI().resolve(string2));
                        }
                        this.inZipPath = string;
                        return null;
                    }
                    return new File(SessionReader.this.sessionFile.toURI().resolve(uRI));
                }
                throw new IOException(I18n.tr("Unsupported scheme ''{0}'' in URI ''{1}''.", uRI.getScheme(), string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
        }

        public boolean isZip() {
            return SessionReader.this.zip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public LinkedHashMap<Integer, SessionLayerImporter> getLayerDependencies() {
            return this.layerDependencies;
        }
    }
}

