/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;

public class CacheFiles {
    public static final int EXPIRE_NEVER = -1;
    public static final int EXPIRE_DAILY = 86400;
    public static final int EXPIRE_WEEKLY = 604800;
    public static final int EXPIRE_MONTHLY = 2419200;
    private final File dir;
    private final String ident;
    private final boolean enabled;
    private long expire;
    private long maxsize;
    private boolean updateModTime = true;
    private static final int CLEANUP_TRESHOLD = 20;
    private static final int CLEANUP_INTERVAL = 5;
    private int writes = 0;
    public static final int CLEAN_ALL = 0;
    public static final int CLEAN_SMALL_FILES = 1;
    public static final int CLEAN_BY_DATE = 2;

    public CacheFiles(String string) {
        this(string, true);
    }

    public CacheFiles(String string, boolean bl) {
        boolean bl2;
        String string2 = bl ? Main.pref.getPluginsDirectory().getPath() + File.separator + "cache" : Main.pref.getCacheDirectory().getPath();
        this.ident = string;
        String string3 = Main.pref.get("cache." + string + "." + "path", string2 + File.separator + string + File.separator);
        this.dir = new File(string3);
        try {
            this.dir.mkdirs();
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        this.enabled = bl2;
        this.expire = Main.pref.getLong("cache." + string + "." + "expire", 86400L);
        if (this.expire < 0L) {
            this.expire = -1L;
        }
        this.maxsize = Main.pref.getLong("cache." + string + "." + "maxsize", 50L);
        if (this.maxsize < 0L) {
            this.maxsize = -1L;
        }
    }

    public byte[] getData(String string) {
        if (!this.enabled) {
            return null;
        }
        try {
            File file = this.getPath(string);
            if (!file.exists()) {
                return null;
            }
            if (this.isExpired(file)) {
                file.delete();
                return null;
            }
            if (this.updateModTime) {
                file.setLastModified(new Date().getTime());
            }
            byte[] byArray = new byte[(int)file.length()];
            new RandomAccessFile(file, "r").readFully(byArray);
            return byArray;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public void saveData(String string, byte[] byArray) {
        if (!this.enabled) {
            return;
        }
        try {
            File file = this.getPath(string);
            if (file.exists()) {
                file.delete();
            }
            new RandomAccessFile(file, "rws").write(byArray);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        ++this.writes;
        this.checkCleanUp();
    }

    public BufferedImage getImg(String string) {
        if (!this.enabled) {
            return null;
        }
        try {
            File file = this.getPath(string, "png");
            if (!file.exists()) {
                return null;
            }
            if (this.isExpired(file)) {
                file.delete();
                return null;
            }
            if (this.updateModTime) {
                file.setLastModified(new Date().getTime());
            }
            return ImageIO.read(file);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public void saveImg(String string, BufferedImage bufferedImage) {
        if (!this.enabled) {
            return;
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", this.getPath(string, "png"));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        ++this.writes;
        this.checkCleanUp();
    }

    public void setExpire(int n, boolean bl) {
        String string = "cache." + this.ident + "." + "expire";
        if (Main.pref.hasKey(string) && !bl) {
            return;
        }
        this.expire = n > 0 ? (long)n : -1L;
        Main.pref.putLong(string, this.expire);
    }

    public void setMaxSize(int n, boolean bl) {
        String string = "cache." + this.ident + "." + "maxsize";
        if (Main.pref.hasKey(string) && !bl) {
            return;
        }
        this.maxsize = n > 0 ? (long)n : -1L;
        Main.pref.putLong(string, this.maxsize);
    }

    public void setUpdateModTime(boolean bl) {
        this.updateModTime = bl;
    }

    public void checkCleanUp() {
        if (this.writes > 5) {
            this.cleanUp();
        }
    }

    public void cleanUp() {
        if (!this.enabled || this.maxsize == -1L) {
            return;
        }
        TreeMap<Long, File> treeMap = new TreeMap<Long, File>();
        long l = 0L;
        for (File file : this.dir.listFiles()) {
            if (this.isExpired(file)) {
                file.delete();
                continue;
            }
            l += file.length();
            treeMap.put(file.lastModified(), file);
        }
        if (l < this.maxsize * 1000L * 1000L) {
            return;
        }
        Set set = treeMap.keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ((File)treeMap.get(iterator.next())).delete();
            if (++n % 20 != 0 || this.getDirSize() >= this.maxsize) continue;
            return;
        }
        this.writes = 0;
    }

    public void customCleanUp(int n, int n2) {
        switch (n) {
            case 0: {
                for (File file : this.dir.listFiles()) {
                    file.delete();
                }
                break;
            }
            case 1: {
                for (File file : this.dir.listFiles()) {
                    if (file.length() >= (long)n2) continue;
                    file.delete();
                }
                break;
            }
            case 2: {
                this.cleanUp();
            }
        }
    }

    private long getDirSize() {
        if (!this.enabled) {
            return -1L;
        }
        long l = 0L;
        for (File file : this.dir.listFiles()) {
            l += file.length();
        }
        return l;
    }

    private static String getUniqueFilename(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest(string.getBytes()));
            return bigInteger.toString(16);
        }
        catch (Exception exception) {
            string = string.replaceAll("[^a-zA-Z0-9]", "");
            string = string.replaceAll("[acegikmoqsuwy]", "");
            return string.substring(string.length() - 70);
        }
    }

    private File getPath(String string, String string2) {
        return new File(this.dir, CacheFiles.getUniqueFilename(string) + "." + string2);
    }

    private File getPath(String string) {
        return new File(this.dir, CacheFiles.getUniqueFilename(string));
    }

    private boolean isExpired(File file) {
        if (-1L == this.expire) {
            return false;
        }
        return file.lastModified() < new Date().getTime() - this.expire * 1000L;
    }
}

