/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.AudioPreference;
import org.openstreetmap.josm.gui.preferences.BackupPreference;
import org.openstreetmap.josm.gui.preferences.ColorPreference;
import org.openstreetmap.josm.gui.preferences.DrawingPreference;
import org.openstreetmap.josm.gui.preferences.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.LafPreference;
import org.openstreetmap.josm.gui.preferences.LanguagePreference;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.PluginPreference;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.RemoteControlPreference;
import org.openstreetmap.josm.gui.preferences.ServerAccessPreference;
import org.openstreetmap.josm.gui.preferences.ShortcutPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTabbedPane
extends JTabbedPane
implements MouseWheelListener,
ExpertToggleAction.ExpertModeChangeListener {
    private final List<TabData> tabs = new ArrayList<TabData>();
    private static final Collection<PreferenceSettingFactory> settingsFactory = new LinkedList<PreferenceSettingFactory>();
    private final List<PreferenceSetting> settings = new ArrayList<PreferenceSetting>();
    public final JPanel display = this.createPreferenceTab("display", I18n.tr("Display Settings", new Object[0]), I18n.tr("Various settings that influence the visual representation of the whole program.", new Object[0]));
    public final JPanel connection = this.createPreferenceTab("connection", I18n.tr("Connection Settings", new Object[0]), I18n.tr("Connection Settings for the OSM server.", new Object[0]), false);
    public final JPanel map = this.createPreferenceTab("map", I18n.tr("Map Settings", new Object[0]), I18n.tr("Settings for the map projection and data interpretation.", new Object[0]));
    public final JPanel audio = this.createPreferenceTab("audio", I18n.tr("Audio Settings", new Object[0]), I18n.tr("Settings for the audio player and audio markers.", new Object[0]));
    public final JPanel plugins = this.createPreferenceTab("plugin", I18n.tr("Plugins", new Object[0]), I18n.tr("Configure available plugins.", new Object[0]), false);
    public final JTabbedPane displaycontent = new JTabbedPane();
    public final JTabbedPane mapcontent = new JTabbedPane();
    List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    public void addValidationListener(ValidationListener validationListener) {
        this.validationListeners.add(validationListener);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3) {
        return this.createPreferenceTab(string, string2, string3, false);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3, boolean bl) {
        return this.createPreferenceTab(string, string2, string3, bl, false);
    }

    public JPanel createPreferenceTab(String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(string2), GBC.eol().insets(0, 5, 0, 10).anchor(18));
        JLabel jLabel = new JLabel("<html>" + string3 + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        jPanel.add((Component)jLabel, GBC.eol().insets(5, 0, 5, 20).fill(2));
        Object object2 = jPanel;
        if (bl) {
            object2 = object = new JScrollPane(jPanel);
        }
        object = new TabData();
        ((TabData)object).icon = string;
        ((TabData)object).tab = object2;
        ((TabData)object).isExpert = bl2;
        ((TabData)object).toolTip = "<html>" + string3 + "</html>";
        this.tabs.add((TabData)object);
        return jPanel;
    }

    public void selectTabByName(String string) {
        for (TabData tabData : this.tabs) {
            if (!tabData.icon.equals(string)) continue;
            JComponent jComponent = tabData.tab;
            if (jComponent != null) {
                this.setSelectedComponent(jComponent);
            }
            return;
        }
    }

    protected PluginPreference getPluginPreference() {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!(preferenceSetting instanceof PluginPreference)) continue;
            return (PluginPreference)preferenceSetting;
        }
        return null;
    }

    public void savePreferences() {
        if (Main.applet) {
            return;
        }
        PluginPreference pluginPreference = this.getPluginPreference();
        List<PluginInformation> list = pluginPreference.getPluginsScheduledForUpdateOrDownload();
        final PluginDownloadTask pluginDownloadTask = !list.isEmpty() ? new PluginDownloadTask((Component)this, list, I18n.tr("Download plugins", new Object[0])) : null;
        final Runnable runnable = new Runnable(){

            public void run() {
                boolean bl = false;
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() && !pluginDownloadTask.getDownloadedPlugins().isEmpty()) {
                    bl = true;
                }
                for (PreferenceSetting preferenceSetting : PreferenceTabbedPane.this.settings) {
                    if (!preferenceSetting.ok()) continue;
                    bl = true;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled()) {
                    stringBuilder.append(PluginPreference.buildDownloadSummary(pluginDownloadTask));
                }
                if (bl) {
                    stringBuilder.append(I18n.tr("You have to restart JOSM for some settings to take effect.", new Object[0]));
                }
                stringBuilder.append("</html>");
                if (pluginDownloadTask != null && !pluginDownloadTask.isCanceled() || bl) {
                    JOptionPane.showMessageDialog(Main.parent, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
                }
                Main.parent.repaint();
            }
        };
        if (pluginDownloadTask != null) {
            Main.worker.submit(pluginDownloadTask);
            Main.worker.submit(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(runnable);
                }
            });
        } else {
            runnable.run();
        }
    }

    public PreferenceTabbedPane() {
        super(2, 1);
        super.addMouseWheelListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void buildGui() {
        for (PreferenceSettingFactory object : settingsFactory) {
            PreferenceSetting preferenceSetting = object.createPreferenceSetting();
            if (preferenceSetting == null) continue;
            this.settings.add(preferenceSetting);
        }
        this.display.add((Component)this.displaycontent, GBC.eol().fill(1));
        this.map.add((Component)this.mapcontent, GBC.eol().fill(1));
        Iterator<Object> iterator = this.settings.iterator();
        while (iterator.hasNext()) {
            try {
                PreferenceSetting throwable = (PreferenceSetting)iterator.next();
                throwable.addGui(this);
            }
            catch (SecurityException securityException) {
                iterator.remove();
            }
            catch (Throwable throwable) {
                BugReportExceptionHandler.handleException(throwable);
            }
        }
        this.addGUITabs(false);
    }

    private void addGUITabs(boolean bl) {
        boolean bl2 = ExpertToggleAction.isExpert();
        Component component = this.getSelectedComponent();
        if (bl) {
            this.removeAll();
        }
        for (TabData tabData : this.tabs) {
            if (!bl2 && tabData.isExpert) continue;
            this.addTab(null, ImageProvider.get("preferences", tabData.icon), tabData.tab, tabData.toolTip);
        }
        try {
            this.setSelectedComponent(component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void expertChanged(boolean bl) {
        this.addGUITabs(true);
    }

    public List<PreferenceSetting> getSettings() {
        return this.settings;
    }

    public <T> T getSetting(Class<? extends T> clazz) {
        for (PreferenceSetting preferenceSetting : this.settings) {
            if (!clazz.isAssignableFrom(preferenceSetting.getClass())) continue;
            return (T)preferenceSetting;
        }
        return null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (super.indexAtLocation(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y) < 0) {
            return;
        }
        int n = super.getSelectedIndex() + mouseWheelEvent.getWheelRotation();
        n = n < 0 ? 0 : n;
        n = n >= super.getTabCount() ? super.getTabCount() - 1 : n;
        super.setSelectedIndex(n);
    }

    static {
        settingsFactory.add(new DrawingPreference.Factory());
        settingsFactory.add(new ColorPreference.Factory());
        settingsFactory.add(new LafPreference.Factory());
        settingsFactory.add(new LanguagePreference.Factory());
        settingsFactory.add(new ServerAccessPreference.Factory());
        settingsFactory.add(new ProjectionPreference.Factory());
        settingsFactory.add(new MapPaintPreference.Factory());
        settingsFactory.add(new TaggingPresetPreference.Factory());
        settingsFactory.add(new BackupPreference.Factory());
        if (!Main.applet) {
            settingsFactory.add(new PluginPreference.Factory());
        }
        settingsFactory.add(Main.toolbar);
        settingsFactory.add(new AudioPreference.Factory());
        settingsFactory.add(new ShortcutPreference.Factory());
        settingsFactory.add(new ValidatorPreference.Factory());
        settingsFactory.add(new RemoteControlPreference.Factory());
        settingsFactory.add(new ImageryPreference.Factory());
        PluginHandler.getPreferenceSetting(settingsFactory);
        settingsFactory.add(new AdvancedPreference.Factory());
    }

    private static class TabData {
        public String icon;
        public JComponent tab;
        public String toolTip;
        public boolean isExpert;

        private TabData() {
        }
    }

    public static interface ValidationListener {
        public boolean validatePreferences();
    }
}

