/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Image;
import javax.swing.GrayFilter;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapImage<I extends Image> {
    public I img;
    public int alpha = 255;
    public String name;
    public StyleSource source;
    public int width = -1;
    public int height = -1;
    private Image disabledImg;

    public MapImage(String string, StyleSource styleSource) {
        this.name = string;
        this.source = styleSource;
    }

    public Image getDisabled() {
        if (this.disabledImg != null) {
            return this.disabledImg;
        }
        this.disabledImg = GrayFilter.createDisabledImage(this.img);
        return this.disabledImg;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapImage mapImage = (MapImage)object;
        return this.alpha == mapImage.alpha && Utils.equal(this.name, mapImage.name) && Utils.equal(this.source, mapImage.source) && this.width == mapImage.width && this.height == mapImage.height;
    }

    public int hashCode() {
        int n = 7;
        n = 67 * n + this.alpha;
        n = 67 * n + this.name.hashCode();
        n = 67 * n + this.source.hashCode();
        n = 67 * n + this.width;
        n = 67 * n + this.height;
        return n;
    }
}

