/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorDialog
extends ToggleDialog
implements ActionListener,
SelectionChangedListener,
MapView.LayerChangeListener {
    private static final long serialVersionUID = 2952292777351992696L;
    public ValidatorTreePanel tree;
    private SideButton fixButton;
    private SideButton ignoreButton;
    private SideButton selectButton;
    private JPopupMenu popupMenu = new JPopupMenu();
    private TestError popupMenuError = null;
    private DefaultMutableTreeNode lastSelectedNode = null;

    public ValidatorDialog() {
        super(I18n.tr("Validation Results", new Object[0]), "validator", I18n.tr("Open the validation window.", new Object[0]), Shortcut.registerShortcut("subwindow:validator", I18n.tr("Toggle: {0}", I18n.tr("Validation results", new Object[0])), 86, 4, 1), 150);
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Zoom to problem", new Object[0]));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValidatorDialog.this.zoomToProblem();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.tree = new ValidatorTreePanel();
        this.tree.addMouseListener(new ClickWatch());
        this.tree.addTreeSelectionListener(new SelectionWatch());
        LinkedList<SideButton> linkedList = new LinkedList<SideButton>();
        this.selectButton = new SideButton(I18n.marktr("Select"), "select", "Validator", I18n.tr("Set the selected elements on the map to the selected items in the list above.", new Object[0]), this);
        this.selectButton.setEnabled(false);
        linkedList.add(this.selectButton);
        linkedList.add(new SideButton(Main.main.validator.validateAction));
        this.fixButton = new SideButton(I18n.marktr("Fix"), "fix", "Validator", I18n.tr("Fix the selected issue.", new Object[0]), this);
        this.fixButton.setEnabled(false);
        linkedList.add(this.fixButton);
        if (Main.pref.getBoolean("validator.ignore", true)) {
            this.ignoreButton = new SideButton(I18n.marktr("Ignore"), "delete", "Validator", I18n.tr("Ignore the selected issue next time.", new Object[0]), this);
            this.ignoreButton.setEnabled(false);
            linkedList.add(this.ignoreButton);
        } else {
            this.ignoreButton = null;
        }
        this.createLayout(this.tree, true, linkedList);
    }

    @Override
    public void showNotify() {
        DataSet.addSelectionListener(this);
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            this.updateSelection(dataSet.getSelected());
        }
        MapView.addLayerChangeListener(this);
        Layer layer = Main.map.mapView.getActiveLayer();
        if (layer != null) {
            this.activeLayerChange(null, layer);
        }
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
        DataSet.removeSelectionListener(this);
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.tree != null) {
            this.tree.setVisible(bl);
        }
        super.setVisible(bl);
        Main.map.repaint();
    }

    private void fixErrors(ActionEvent actionEvent) {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        LinkedList<TestError> linkedList = new LinkedList<TestError>();
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                if (hashSet.contains(defaultMutableTreeNode2)) continue;
                hashSet.add(defaultMutableTreeNode2);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError)) continue;
                linkedList.add((TestError)object);
            }
        }
        FixTask fixTask = new FixTask(linkedList);
        Main.worker.submit(fixTask);
    }

    private void ignoreErrors(ActionEvent actionEvent) {
        int n = -1;
        boolean bl = false;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (TreePath treePath : treePathArray) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (defaultMutableTreeNode == null) continue;
            Object object6 = defaultMutableTreeNode.getUserObject();
            if (!(object6 instanceof TestError)) {
                object5 = new HashSet();
                if (n == -1) {
                    object4 = new String[]{I18n.tr("Whole group", new Object[0]), I18n.tr("Single elements", new Object[0]), I18n.tr("Nothing", new Object[0])};
                    n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("Ignore whole group or individual elements?", new Object[0]), I18n.tr("Ignoring elements", new Object[0]), 1, 2, null, object4, object4[1]);
                }
                if (n == 0) {
                    object4 = defaultMutableTreeNode.breadthFirstEnumeration();
                    while (object4.hasMoreElements()) {
                        object3 = (DefaultMutableTreeNode)object4.nextElement();
                        if (hashSet.contains(object3)) continue;
                        hashSet.add(object3);
                        object2 = ((DefaultMutableTreeNode)object3).getUserObject();
                        if (!(object2 instanceof TestError)) continue;
                        object = (TestError)object2;
                        ((TestError)object).setIgnored(true);
                        bl = true;
                        object5.add(defaultMutableTreeNode.getDepth() == 1 ? ((TestError)object).getIgnoreSubGroup() : ((TestError)object).getIgnoreGroup());
                    }
                    object3 = object5.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        OsmValidator.addIgnoredError((String)object2);
                    }
                    continue;
                }
                if (n == 2) continue;
            }
            object5 = defaultMutableTreeNode.breadthFirstEnumeration();
            while (object5.hasMoreElements()) {
                object4 = (DefaultMutableTreeNode)object5.nextElement();
                if (hashSet.contains(object4)) continue;
                hashSet.add(object4);
                object3 = object4.getUserObject();
                if (!(object3 instanceof TestError)) continue;
                object2 = (TestError)object3;
                object = ((TestError)object2).getIgnoreState();
                if (object != null) {
                    OsmValidator.addIgnoredError((String)object);
                }
                bl = true;
                ((TestError)object2).setIgnored(true);
            }
        }
        if (bl) {
            this.tree.resetErrors();
            OsmValidator.saveIgnoredErrors();
            Main.map.repaint();
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        this.popupMenuError = null;
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        if (!(defaultMutableTreeNode.getUserObject() instanceof TestError)) {
            return;
        }
        this.popupMenuError = (TestError)defaultMutableTreeNode.getUserObject();
        this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void zoomToProblem() {
        if (this.popupMenuError == null) {
            return;
        }
        ValidatorBoundingXYVisitor validatorBoundingXYVisitor = new ValidatorBoundingXYVisitor();
        this.popupMenuError.visitHighlighted(validatorBoundingXYVisitor);
        if (validatorBoundingXYVisitor.getBounds() == null) {
            return;
        }
        validatorBoundingXYVisitor.enlargeBoundingBox(Main.pref.getDouble("validator.zoom-enlarge-bbox", 2.0E-4));
        Main.map.mapView.recalculateCenterScale(validatorBoundingXYVisitor);
    }

    private void setSelectedItems() {
        if (this.tree == null) {
            return;
        }
        HashSet<? extends OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(40);
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Object object = defaultMutableTreeNode2.getUserObject();
                if (!(object instanceof TestError)) continue;
                TestError testError = (TestError)object;
                hashSet.addAll(testError.getSelectablePrimitives());
            }
        }
        Main.main.getCurrentDataSet().setSelected(hashSet);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Select")) {
            this.setSelectedItems();
        } else if (string.equals("Fix")) {
            this.fixErrors(actionEvent);
        } else if (string.equals("Ignore")) {
            this.ignoreErrors(actionEvent);
        }
    }

    private boolean setSelection(Collection<OsmPrimitive> collection, boolean bl) {
        TestError testError;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Enumeration<TreeNode> enumeration;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.lastSelectedNode != null && !this.lastSelectedNode.equals(defaultMutableTreeNode2)) {
            enumeration = this.lastSelectedNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof TestError)) continue;
                testError = (TestError)object;
                testError.setSelected(false);
            }
        }
        this.lastSelectedNode = defaultMutableTreeNode2;
        if (defaultMutableTreeNode2 == null) {
            return bl2;
        }
        enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof TestError)) continue;
            testError = (TestError)object;
            testError.setSelected(true);
            boolean bl3 = bl2 = bl2 || testError.isFixable();
            if (!bl) continue;
            collection.addAll(testError.getPrimitives());
        }
        this.selectButton.setEnabled(true);
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(true);
        }
        return bl2;
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        if (layer2 instanceof OsmDataLayer) {
            this.tree.setErrorList(((OsmDataLayer)layer2).validationErrors);
        }
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
    }

    public void updateSelection(Collection<? extends OsmPrimitive> collection) {
        if (!Main.pref.getBoolean("validator.selectionFilter", false)) {
            return;
        }
        if (collection.isEmpty()) {
            this.tree.setFilter(null);
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        this.tree.setFilter(hashSet);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.updateSelection(collection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FixTask
    extends PleaseWaitRunnable {
        private Collection<TestError> testErrors;
        private boolean canceled;

        public FixTask(Collection<TestError> arrayList) {
            super(I18n.tr("Fixing errors ...", new Object[0]), false);
            this.testErrors = arrayList == null ? new ArrayList() : arrayList;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            ProgressMonitor progressMonitor = this.getProgressMonitor();
            try {
                progressMonitor.setTicksCount(this.testErrors.size());
                int n = 0;
                for (TestError testError : this.testErrors) {
                    progressMonitor.subTask(I18n.tr("Fixing ({0}/{1}): ''{2}''", ++n, this.testErrors.size(), testError.getMessage()));
                    if (this.canceled) {
                        return;
                    }
                    final Command command = testError.getFix();
                    if (command != null) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                Main.main.undoRedo.addNoRedraw(command);
                            }
                        });
                        testError.setIgnored(true);
                    }
                    progressMonitor.worked(1);
                }
                progressMonitor.subTask(I18n.tr("Updating map ...", new Object[0]));
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Main.main.undoRedo.afterAdd();
                        Main.map.repaint();
                        ValidatorDialog.this.tree.resetErrors();
                        Main.main.getCurrentDataSet().fireSelectionChanged();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            finally {
                progressMonitor.finishTask();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidatorBoundingXYVisitor
    extends BoundingXYVisitor
    implements ValidatorVisitor {
        @Override
        public void visit(OsmPrimitive osmPrimitive) {
            if (osmPrimitive.isUsable()) {
                osmPrimitive.visit(this);
            }
        }

        @Override
        public void visit(WaySegment waySegment) {
            if (waySegment.lowerIndex < 0 || waySegment.lowerIndex + 1 >= waySegment.way.getNodesCount()) {
                return;
            }
            this.visit(waySegment.way.getNodes().get(waySegment.lowerIndex));
            this.visit(waySegment.way.getNodes().get(waySegment.lowerIndex + 1));
        }

        @Override
        public void visit(List<Node> list) {
            for (Node node : list) {
                this.visit(node);
            }
        }
    }

    public class SelectionWatch
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean bl = ValidatorDialog.this.setSelection(null, false);
            ValidatorDialog.this.fixButton.setEnabled(bl);
            Main.map.repaint();
        }
    }

    public class ClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ValidatorDialog.this.fixButton.setEnabled(false);
            if (ValidatorDialog.this.ignoreButton != null) {
                ValidatorDialog.this.ignoreButton.setEnabled(false);
            }
            ValidatorDialog.this.selectButton.setEnabled(false);
            boolean bl = mouseEvent.getClickCount() > 1;
            HashSet<OsmPrimitive> hashSet = bl ? new HashSet<OsmPrimitive>(40) : null;
            boolean bl2 = ValidatorDialog.this.setSelection(hashSet, bl);
            ValidatorDialog.this.fixButton.setEnabled(bl2);
            if (bl) {
                Main.main.getCurrentDataSet().setSelected(hashSet);
                if (Main.pref.getBoolean("validator.autozoom", false)) {
                    AutoScaleAction.zoomTo(hashSet);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ValidatorDialog.this.showPopupMenu(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ValidatorDialog.this.showPopupMenu(mouseEvent);
        }
    }
}

