/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePropertyKeyCommand
extends Command {
    private final List<OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.objects = new LinkedList<OsmPrimitive>(collection);
        this.key = string;
        this.newKey = string2;
    }

    @Override
    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osmPrimitive : this.objects) {
            if (!osmPrimitive.hasKeys()) continue;
            osmPrimitive.setModified(true);
            String string = osmPrimitive.get(this.key);
            osmPrimitive.put(this.newKey, string);
            osmPrimitive.remove(this.key);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public JLabel getDescription() {
        String string = I18n.tr("Replace \"{0}\" by \"{1}\" for", this.key, this.newKey);
        if (this.objects.size() == 1) {
            NameVisitor nameVisitor = new NameVisitor();
            this.objects.iterator().next().visit(nameVisitor);
            string = string + " " + I18n.tr(nameVisitor.className, new Object[0]) + " " + nameVisitor.name;
        } else {
            string = string + " " + this.objects.size() + " " + I18n.trn("object", "objects", this.objects.size(), new Object[0]);
        }
        return new JLabel(string, ImageProvider.get("data", "key"), 0);
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>();
        final NameVisitor nameVisitor = new NameVisitor();
        for (final OsmPrimitive osmPrimitive : this.objects) {
            osmPrimitive.visit(nameVisitor);
            arrayList.add(new PseudoCommand(){

                @Override
                public JLabel getDescription() {
                    return nameVisitor.toLabel();
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return arrayList;
    }
}

