/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 82, 0), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    public static String getReportHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Version.getInstance().getReleaseAttributes());
        stringBuilder.append("\n");
        stringBuilder.append("Identification: " + Version.getInstance().getAgentString());
        stringBuilder.append("\n");
        stringBuilder.append("Memory Usage: ");
        stringBuilder.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        stringBuilder.append(" MB / ");
        stringBuilder.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        stringBuilder.append(" MB (");
        stringBuilder.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        stringBuilder.append(" MB allocated, but free)");
        stringBuilder.append("\n");
        stringBuilder.append("Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("java.vm.name"));
        stringBuilder.append("\n");
        stringBuilder.append("Operating system: " + System.getProperty("os.name"));
        stringBuilder.append("\n");
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            String string = DatasetConsistencyTest.runTests(dataSet);
            if (string.length() == 0) {
                stringBuilder.append("Dataset consistency test: No problems found\n");
            } else {
                stringBuilder.append("\nDataset consistency test:\n" + string + "\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append(PluginHandler.getBugReportText());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ShowStatusReportAction.getReportHeader());
        try {
            object2 = Main.pref.getAllSettings();
            object2.remove("osm-server.username");
            object2.remove("osm-server.password");
            object2.remove("oauth.access-token.key");
            object2.remove("oauth.access-token.secret");
            serializable = new HashSet(object2.keySet());
            object = serializable.iterator();
            while (object.hasNext()) {
                String object3 = (String)object.next();
                if (!object3.startsWith("marker.show")) continue;
                object2.remove(object3);
            }
            for (Map.Entry entry : object2.entrySet()) {
                stringBuilder.append((String)entry.getKey()).append("=").append(((Preferences.Setting)entry.getValue()).getValue().toString()).append("\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = new JTextArea(stringBuilder.toString());
        ((JTextArea)object2).setWrapStyleWord(true);
        ((JTextArea)object2).setLineWrap(true);
        ((JTextComponent)object2).setEditable(false);
        serializable = new JScrollPane((Component)object2);
        object = new ExtendedDialog(Main.parent, I18n.tr("Status Report", new Object[0]), new String[]{I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Close", new Object[0])});
        ((ExtendedDialog)object).setButtonIcons(new String[]{"copy.png", "cancel.png"});
        ((ExtendedDialog)object).setContent((Component)serializable, false);
        ((Window)object).setMinimumSize(new Dimension(500, 0));
        ((ExtendedDialog)object).showDialog();
        if (((ExtendedDialog)object).getValue() != 1) {
            return;
        }
        Utils.copyToClipboard(stringBuilder.toString());
    }
}

