/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmFileCacheTileLoader
extends OsmTileLoader {
    private static final Logger log = Logger.getLogger(OsmFileCacheTileLoader.class.getName());
    private static final String ETAG_FILE_EXT = ".etag";
    private static final String TAGS_FILE_EXT = ".tags";
    private static final Charset TAGS_CHARSET = Charset.forName("UTF-8");
    public static final long FILE_AGE_ONE_DAY = 86400000L;
    public static final long FILE_AGE_ONE_WEEK = 604800000L;
    protected String cacheDirBase;
    protected final Map<TileSource, File> sourceCacheDirMap;
    protected long maxCacheFileAge = 604800000L;
    protected long recheckAfter = 86400000L;

    public static File getDefaultCacheDir() throws SecurityException {
        String string = null;
        String string2 = System.getProperty("user.name");
        try {
            string = System.getProperty("java.io.tmpdir");
        }
        catch (SecurityException securityException) {
            log.log(Level.WARNING, "Failed to access system property ''java.io.tmpdir'' for security reasons. Exception was: " + securityException.toString());
            throw securityException;
        }
        try {
            if (string == null) {
                throw new IOException("No temp directory set");
            }
            String string3 = "JMapViewerTiles";
            if (string2 != null && string2.length() > 0) {
                string3 = string3 + "_" + string2;
            }
            File file = new File(string, string3);
            return file;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OsmFileCacheTileLoader(TileLoaderListener tileLoaderListener, File file) throws IOException {
        super(tileLoaderListener);
        if (file == null || !file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        log.finest("Tile cache directory: " + file);
        this.cacheDirBase = file.getAbsolutePath();
        this.sourceCacheDirMap = new HashMap<TileSource, File>();
    }

    public OsmFileCacheTileLoader(TileLoaderListener tileLoaderListener) throws SecurityException, IOException {
        this(tileLoaderListener, OsmFileCacheTileLoader.getDefaultCacheDir());
    }

    public Runnable createTileLoaderJob(TileSource tileSource, int n, int n2, int n3) {
        return new FileLoadJob(tileSource, n, n2, n3);
    }

    protected File getSourceCacheDir(TileSource tileSource) {
        File file = this.sourceCacheDirMap.get(tileSource);
        if (file == null && !(file = new File(this.cacheDirBase, tileSource.getName().replaceAll("[\\\\/:*?\"<>|]", "_"))).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public long getMaxFileAge() {
        return this.maxCacheFileAge;
    }

    public void setCacheMaxFileAge(long l) {
        this.maxCacheFileAge = l;
    }

    public String getCacheDirBase() {
        return this.cacheDirBase;
    }

    public void setTileCacheDir(String string) {
        File file = new File(string);
        file.mkdirs();
        this.cacheDirBase = file.getAbsolutePath();
    }

    public void clearCache(TileSource tileSource) {
        File file = this.getSourceCacheDir(tileSource);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                file2.delete();
            }
        }
        file.delete();
    }

    protected class FileLoadJob
    implements Runnable {
        InputStream input = null;
        int tilex;
        int tiley;
        int zoom;
        Tile tile;
        TileSource source;
        File tileCacheDir;
        File tileFile = null;
        long fileAge = 0L;
        boolean fileTilePainted = false;

        public FileLoadJob(TileSource tileSource, int n, int n2, int n3) {
            this.source = tileSource;
            this.tilex = n;
            this.tiley = n2;
            this.zoom = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TileCache tileCache = OsmFileCacheTileLoader.this.listener.getTileCache();
            Object object = tileCache;
            synchronized (object) {
                this.tile = tileCache.getTile(this.source, this.tilex, this.tiley, this.zoom);
                if (this.tile == null || this.tile.isLoaded() && !this.tile.hasError() || this.tile.loading) {
                    return;
                }
                this.tile.loaded = false;
                this.tile.error = false;
                this.tile.loading = true;
            }
            this.tileCacheDir = OsmFileCacheTileLoader.this.getSourceCacheDir(this.source);
            if (this.loadTileFromFile()) {
                return;
            }
            if (this.fileTilePainted) {
                object = new Runnable(){

                    public void run() {
                        FileLoadJob.this.loadOrUpdateTile();
                    }
                };
                JobDispatcher.getInstance().addJob((Runnable)object);
            } else {
                this.loadOrUpdateTile();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void loadOrUpdateTile() {
            block24: {
                try {
                    URLConnection uRLConnection = OsmFileCacheTileLoader.this.loadTileFromOsm(this.tile);
                    if (this.tileFile != null) {
                        switch (this.source.getTileUpdate()) {
                            case IfModifiedSince: {
                                uRLConnection.setIfModifiedSince(this.fileAge);
                                break;
                            }
                            case LastModified: {
                                if (this.isOsmTileNewer(this.fileAge)) break;
                                log.finest("LastModified test: local version is up to date: " + this.tile);
                                this.tile.setLoaded(true);
                                this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                                return;
                            }
                        }
                    }
                    if (this.source.getTileUpdate() == TileSource.TileUpdate.ETag || this.source.getTileUpdate() == TileSource.TileUpdate.IfNoneMatch) {
                        String string = this.tile.getValue("etag");
                        if (string != null) {
                            switch (this.source.getTileUpdate()) {
                                case IfNoneMatch: {
                                    uRLConnection.addRequestProperty("If-None-Match", string);
                                    break;
                                }
                                case ETag: {
                                    if (!this.hasOsmTileETag(string)) break;
                                    this.tile.setLoaded(true);
                                    this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                                    return;
                                }
                            }
                        }
                        this.tile.putValue("etag", uRLConnection.getHeaderField("ETag"));
                    }
                    if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() == 304) {
                        log.finest("ETag test: local version is up to date: " + this.tile);
                        this.tile.setLoaded(true);
                        this.tileFile.setLastModified(System.currentTimeMillis() - OsmFileCacheTileLoader.this.maxCacheFileAge + OsmFileCacheTileLoader.this.recheckAfter);
                        return;
                    }
                    OsmFileCacheTileLoader.this.loadTileMetadata(this.tile, uRLConnection);
                    this.saveTagsToFile();
                    if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                        this.tile.setError("No tile at this zoom level");
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                        break block24;
                    }
                    for (int i = 0; i < 5; ++i) {
                        if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() == 503) {
                            Thread.sleep(5000 + new Random().nextInt(5000));
                            continue;
                        }
                        byte[] byArray = this.loadTileInBuffer(uRLConnection);
                        if (byArray == null) continue;
                        this.tile.loadImage(new ByteArrayInputStream(byArray));
                        this.tile.setLoaded(true);
                        OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                        this.saveTileToFile(byArray);
                        break;
                    }
                }
                catch (Exception exception) {
                    this.tile.setError(exception.getMessage());
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, false);
                    if (this.input == null) {
                        System.err.println("failed loading " + this.zoom + "/" + this.tilex + "/" + this.tiley + " " + exception.getMessage());
                    }
                }
                finally {
                    this.tile.loading = false;
                    this.tile.setLoaded(true);
                }
            }
        }

        protected boolean loadTileFromFile() {
            FileInputStream fileInputStream = null;
            try {
                boolean bl;
                this.tileFile = this.getTileFile();
                this.loadTagsFromFile();
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                    if (this.tileFile.exists()) {
                        this.tileFile.delete();
                    }
                    this.tileFile = this.getTagsFile();
                } else {
                    fileInputStream = new FileInputStream(this.tileFile);
                    if (fileInputStream.available() == 0) {
                        throw new IOException("File empty");
                    }
                    this.tile.loadImage(fileInputStream);
                    fileInputStream.close();
                }
                this.fileAge = this.tileFile.lastModified();
                boolean bl2 = bl = System.currentTimeMillis() - this.fileAge > OsmFileCacheTileLoader.this.maxCacheFileAge;
                if (!bl) {
                    this.tile.setLoaded(true);
                    OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                    this.fileTilePainted = true;
                    return true;
                }
                OsmFileCacheTileLoader.this.listener.tileLoadingFinished(this.tile, true);
                this.fileTilePainted = true;
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                        this.tileFile.delete();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.tileFile = null;
                this.fileAge = 0L;
            }
            return false;
        }

        protected byte[] loadTileInBuffer(URLConnection uRLConnection) throws IOException {
            this.input = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.input.available());
            byte[] byArray = new byte[2048];
            boolean bl = false;
            do {
                int n;
                if ((n = this.input.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    continue;
                }
                bl = true;
            } while (!bl);
            if (byteArrayOutputStream.size() == 0) {
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected boolean isOsmTileNewer(long l) throws IOException {
            URL uRL = new URL(this.tile.getUrl());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(httpURLConnection);
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setReadTimeout(30000);
            long l2 = httpURLConnection.getLastModified();
            if (l2 == 0L) {
                return true;
            }
            return l2 > l;
        }

        protected boolean hasOsmTileETag(String string) throws IOException {
            URL uRL = new URL(this.tile.getUrl());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            OsmFileCacheTileLoader.this.prepareHttpUrlConnection(httpURLConnection);
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setReadTimeout(30000);
            String string2 = httpURLConnection.getHeaderField("ETag");
            if (string2 == null) {
                return true;
            }
            return string2.equals(string);
        }

        protected File getTileFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
        }

        protected File getTagsFile() {
            return new File(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.TAGS_FILE_EXT);
        }

        protected void saveTileToFile(byte[] byArray) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.tileCacheDir + "/" + this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + "." + this.source.getTileType());
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Failed to save tile content: " + exception.getLocalizedMessage());
            }
        }

        protected void saveTagsToFile() {
            File file = this.getTagsFile();
            if (this.tile.getMetadata() == null) {
                file.delete();
                return;
            }
            try {
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), TAGS_CHARSET));
                for (Map.Entry<String, String> entry : this.tile.getMetadata().entrySet()) {
                    printWriter.println(entry.getKey() + "=" + entry.getValue());
                }
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Failed to save tile tags: " + exception.getLocalizedMessage());
            }
        }

        private void loadOldETagfromFile() {
            File file = new File(this.tileCacheDir, this.tile.getZoom() + "_" + this.tile.getXtile() + "_" + this.tile.getYtile() + OsmFileCacheTileLoader.ETAG_FILE_EXT);
            if (!file.exists()) {
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                String string = new String(byArray, TAGS_CHARSET.name());
                this.tile.putValue("etag", string);
                if (file.delete()) {
                    this.saveTagsToFile();
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed to load compatiblity etag: " + iOException.getLocalizedMessage());
            }
        }

        protected void loadTagsFromFile() {
            this.loadOldETagfromFile();
            File file = this.getTagsFile();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), TAGS_CHARSET));
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf(61);
                    if (n == -1 || n == 0) {
                        System.err.println("Malformed tile tag in file '" + file.getName() + "':" + string);
                    } else {
                        this.tile.putValue(string.substring(0, n), string.substring(n + 1));
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                System.err.println("Failed to load tile tags: " + exception.getLocalizedMessage());
            }
        }
    }
}

