/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintPreference
implements PreferenceSetting {
    private SourceEditor sources;
    private JCheckBox enableIconDefault;

    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        this.enableIconDefault = new JCheckBox(I18n.tr("Enable built-in icon defaults", new Object[0]), Main.pref.getBoolean("mappaint.icon.enable-defaults", true));
        this.sources = new MapPaintSourceEditor();
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.sources, GBC.eol().fill(1));
        jPanel.add((Component)this.enableIconDefault, GBC.eol().insets(11, 2, 5, 0));
        preferenceTabbedPane.mapcontent.addTab(I18n.tr("Map Paint Styles", new Object[0]), jPanel);
        preferenceTabbedPane.mapcontent.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (preferenceTabbedPane.mapcontent.getSelectedComponent() == jPanel) {
                    MapPaintPreference.this.sources.initiallyLoadAvailableSources();
                }
            }
        });
    }

    public boolean ok() {
        boolean bl = Main.pref.put("mappaint.icon.enable-defaults", this.enableIconDefault.isSelected());
        if (bl |= this.sources.finish()) {
            MapPaintStyles.readFromPreferences();
        }
        if (Main.isDisplayingMapView()) {
            MapPaintStyles.getStyles().clearCached();
        }
        return false;
    }

    public static void initialize() {
        MapPaintStyles.readFromPreferences();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapPaintPrefMigration
    extends SourceEditor.SourcePrefMigration {
        public static final MapPaintPrefMigration INSTANCE = new MapPaintPrefMigration();

        public MapPaintPrefMigration() {
            super("mappaint.style.sources", "mappaint.style.enable-defaults", "mappaint.style.sources-list");
        }

        @Override
        public List<SourceEntry> get() {
            List<SourceEntry> list = super.get();
            if (this.adapt_elemstyles_xml(list)) {
                this.put(list);
            }
            if (this.insertNewDefaults(list)) {
                this.put(list);
            }
            return list;
        }

        private boolean adapt_elemstyles_xml(List<SourceEntry> list) {
            boolean bl = false;
            for (SourceEntry sourceEntry : list) {
                if (!sourceEntry.url.equals("resource://data/elemstyles.xml")) continue;
                sourceEntry.url = "resource://styles/standard/elemstyles.xml";
                bl = true;
            }
            return bl;
        }

        private boolean insertNewDefaults(List<SourceEntry> list) {
            boolean bl = false;
            TreeSet<String> treeSet = new TreeSet<String>(Main.pref.getCollection("mappaint.style.known-defaults"));
            Collection<SourceEditor.ExtendedSourceEntry> collection = this.getDefault();
            int n = 0;
            for (final SourceEditor.ExtendedSourceEntry extendedSourceEntry : collection) {
                int n2 = Utils.indexOf(list, new Predicate<SourceEntry>(){

                    @Override
                    public boolean evaluate(SourceEntry sourceEntry) {
                        return Utils.equal(extendedSourceEntry.url, sourceEntry.url);
                    }
                });
                if (n2 == -1 && !treeSet.contains(extendedSourceEntry.url)) {
                    list.add(n, extendedSourceEntry);
                    ++n;
                    bl = true;
                    continue;
                }
                if (n2 < n) continue;
                n = n2 + 1;
            }
            for (final SourceEditor.ExtendedSourceEntry extendedSourceEntry : collection) {
                treeSet.add(extendedSourceEntry.url);
            }
            Main.pref.putCollection("mappaint.style.known-defaults", treeSet);
            return bl;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            SourceEditor.ExtendedSourceEntry extendedSourceEntry = new SourceEditor.ExtendedSourceEntry("elemstyles.xml", "resource://styles/standard/elemstyles.xml");
            extendedSourceEntry.active = true;
            extendedSourceEntry.name = "standard";
            extendedSourceEntry.title = I18n.tr("JOSM Internal Style", new Object[0]);
            extendedSourceEntry.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles", new Object[0]);
            SourceEditor.ExtendedSourceEntry extendedSourceEntry2 = new SourceEditor.ExtendedSourceEntry("potlatch2.mapcss", "resource://styles/standard/potlatch2.mapcss");
            extendedSourceEntry2.active = false;
            extendedSourceEntry2.name = "standard";
            extendedSourceEntry2.title = I18n.tr("Potlatch 2", new Object[0]);
            extendedSourceEntry2.description = I18n.tr("the main Potlatch 2 style", new Object[0]);
            return Arrays.asList(extendedSourceEntry, extendedSourceEntry2);
        }

        @Override
        public Collection<String> serialize(SourceEntry sourceEntry) {
            return Arrays.asList(sourceEntry.url, sourceEntry.name == null ? "" : sourceEntry.name, sourceEntry.title == null ? "" : sourceEntry.title, Boolean.toString(sourceEntry.active));
        }

        @Override
        public SourceEntry deserialize(List<String> list) {
            if (list.size() < 4) {
                return null;
            }
            String string = list.get(0);
            String string2 = list.get(1);
            String string3 = list.get(2);
            boolean bl = Boolean.parseBoolean(list.get(3));
            return new SourceEntry(string, string2, string3, bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapPaintSourceEditor
    extends SourceEditor {
        private final String iconpref = "mappaint.icon.sources";

        public MapPaintSourceEditor() {
            super(true, "http://josm.openstreetmap.de/styles");
            this.iconpref = "mappaint.icon.sources";
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return MapPaintPrefMigration.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            List<SourceEntry> list = this.activeSourcesModel.getSources();
            boolean bl = MapPaintPrefMigration.INSTANCE.put(list);
            if (this.tblIconPaths != null) {
                List<String> list2 = this.iconPathsModel.getIconPaths();
                if (!list2.isEmpty()) {
                    if (Main.pref.putCollection("mappaint.icon.sources", list2)) {
                        bl = true;
                    }
                } else if (Main.pref.putCollection("mappaint.icon.sources", null)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return MapPaintPrefMigration.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return Main.pref.getCollection("mappaint.icon.sources", null);
        }

        @Override
        public String getStr(SourceEditor.I18nString i18nString) {
            switch (i18nString) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available styles:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active styles:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new style by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New style entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected styles from the list of active styles", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active style", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available styles to the list of active styles", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available styles from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading style sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of style sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Styles#FailedToLoadStyleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new MapPaintPreference();
        }
    }
}

