/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;

public abstract class Prototype {
    public Range range;
    public int priority;
    public String code;
    public Collection<XmlCondition> conditions = null;

    public Prototype(Range range) {
        this.range = range;
    }

    public Prototype() {
    }

    public String getCode() {
        if (this.code == null) {
            this.code = "";
            if (this.conditions != null) {
                for (XmlCondition xmlCondition : this.conditions) {
                    this.code = this.code + xmlCondition.toCode();
                }
            }
        }
        return this.code;
    }

    public boolean check(OsmPrimitive osmPrimitive) {
        if (this.conditions == null) {
            return true;
        }
        for (XmlCondition xmlCondition : this.conditions) {
            String string = osmPrimitive.get(xmlCondition.key);
            String string2 = OsmUtils.getNamedOsmBoolean(xmlCondition.boolValue);
            if (string != null && (xmlCondition.value == null || string.equals(xmlCondition.value)) && (string2 == null || string2.equals(OsmUtils.getNamedOsmBoolean(string)))) continue;
            return false;
        }
        return true;
    }
}

