/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.awt.Color;
import java.util.List;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.Prototype;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePrototype
extends Prototype {
    protected int width;
    public Integer realWidth;
    public Color color;
    protected List<Float> dashed;
    public Color dashedColor;

    public LinePrototype(LinePrototype linePrototype, Range range) {
        super(range);
        this.width = linePrototype.width;
        this.realWidth = linePrototype.realWidth;
        this.color = linePrototype.color;
        this.dashed = linePrototype.dashed;
        this.dashedColor = linePrototype.dashedColor;
        this.priority = linePrototype.priority;
        this.conditions = linePrototype.conditions;
    }

    public LinePrototype() {
        this.init();
    }

    public void init() {
        this.priority = 0;
        this.range = new Range();
        this.width = -1;
        this.realWidth = null;
        this.dashed = null;
        this.dashedColor = null;
        this.color = PaintColors.UNTAGGED.get();
    }

    public List<Float> getDashed() {
        return this.dashed;
    }

    public void setDashed(List<Float> list) {
        if (list == null || list.isEmpty()) {
            this.dashed = null;
            return;
        }
        boolean bl = false;
        for (Float f : list) {
            if (f == null) {
                this.dashed = null;
                return;
            }
            if (f.floatValue() > 0.0f) {
                bl = true;
            }
            if (!(f.floatValue() < 0.0f)) continue;
            System.err.println(I18n.tr("Illegal dash pattern, values must be positive", new Object[0]));
            this.dashed = null;
            return;
        }
        if (bl) {
            this.dashed = list;
        } else {
            System.err.println(I18n.tr("Illegal dash pattern, at least one value must be > 0", new Object[0]));
        }
    }

    public int getWidth() {
        if (this.width == -1) {
            return MapPaintSettings.INSTANCE.getDefaultSegmentWidth();
        }
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }
}

