/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatePrimitivesVisitor
extends AbstractVisitor {
    final Collection<OsmPrimitive> aggregatedData = new HashSet<OsmPrimitive>();

    public Collection<OsmPrimitive> visit(Collection<OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.visit(this);
        }
        return this.aggregatedData;
    }

    @Override
    public void visit(Node node) {
        if (!this.aggregatedData.contains(node)) {
            this.aggregatedData.add(node);
        }
    }

    @Override
    public void visit(Way way) {
        if (!this.aggregatedData.contains(way)) {
            this.aggregatedData.add(way);
            for (Node node : way.getNodes()) {
                this.visit(node);
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (!this.aggregatedData.contains(relation)) {
            this.aggregatedData.add(relation);
            for (RelationMember relationMember : relation.getMembers()) {
                relationMember.getMember().visit(this);
            }
        }
    }
}

