/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingInBuilding
extends Test {
    protected static int BUILDING_INSIDE_BUILDING = 2001;
    protected List<OsmPrimitive> primitivesToCheck = new LinkedList<OsmPrimitive>();
    protected QuadBuckets<Way> index = new QuadBuckets();

    public BuildingInBuilding() {
        super(I18n.tr("Building inside building", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && BuildingInBuilding.isBuilding(node)) {
            this.primitivesToCheck.add(node);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable() && way.isClosed() && BuildingInBuilding.isBuilding(way)) {
            this.primitivesToCheck.add(way);
            this.index.add(way);
        }
    }

    private static boolean isInPolygon(Node node, List<Node> list) {
        return Geometry.nodeInsidePolygon(node, list);
    }

    private static boolean isInPolygon(Way way, List<Node> list) {
        for (Node node : way.getNodes()) {
            if (BuildingInBuilding.isInPolygon(node, list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void endTest() {
        for (final OsmPrimitive osmPrimitive : this.primitivesToCheck) {
            Collection<Way> collection = this.index.search(osmPrimitive.getBBox());
            if ((collection = new FilteredCollection<Way>(collection, new Predicate<Way>(){

                @Override
                public boolean evaluate(Way way) {
                    if (osmPrimitive.equals(way)) {
                        return false;
                    }
                    if (osmPrimitive instanceof Node) {
                        return BuildingInBuilding.isInPolygon((Node)osmPrimitive, (List<Node>)way.getNodes()) || way.getNodes().contains((Node)osmPrimitive);
                    }
                    if (osmPrimitive instanceof Way) {
                        return BuildingInBuilding.isInPolygon((Way)osmPrimitive, (List<Node>)way.getNodes());
                    }
                    return false;
                }
            })).isEmpty()) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Building inside building", new Object[0]), BUILDING_INSIDE_BUILDING, osmPrimitive));
        }
    }

    private static boolean isBuilding(OsmPrimitive osmPrimitive) {
        return "yes".equals(osmPrimitive.get("building"));
    }
}

