/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Epsg3008;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.GaussKrueger;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.LambertEST;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Puwg;
import org.openstreetmap.josm.data.projection.SwissGrid;
import org.openstreetmap.josm.data.projection.TransverseMercatorLV;
import org.openstreetmap.josm.data.projection.UTM;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projections {
    private static ArrayList<Projection> allProjections = new ArrayList<Projection>(Arrays.asList(new Epsg4326(), new Mercator(), new UTM(), new GaussKrueger(), new LambertEST(), new Lambert(), new LambertCC9Zones(), new UTM_France_DOM(), new TransverseMercatorLV(), new Puwg(), new Epsg3008(), new SwissGrid()));

    public static ArrayList<Projection> getProjections() {
        return allProjections;
    }

    public static void addProjection(Projection projection) {
        allProjections.add(projection);
    }

    public static EastNorth project(LatLon latLon) {
        if (latLon == null) {
            return null;
        }
        return Main.getProjection().latlon2eastNorth(latLon);
    }

    public static LatLon inverseProject(EastNorth eastNorth) {
        if (eastNorth == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(eastNorth);
    }
}

