/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussKrueger
extends AbstractProjection
implements ProjectionSubPrefs {
    public static int DEFAULT_ZONE = 2;
    private int zone;
    private static Bounds[] bounds = new Bounds[]{new Bounds(new LatLon(-5.0, 3.5), new LatLon(85.0, 8.5)), new Bounds(new LatLon(-5.0, 6.5), new LatLon(85.0, 11.5)), new Bounds(new LatLon(-5.0, 9.5), new LatLon(85.0, 14.5)), new Bounds(new LatLon(-5.0, 12.5), new LatLon(85.0, 17.5))};
    private static NTV2GridShiftFile BETA2007 = null;
    private static String[] zones = new String[]{"2", "3", "4", "5"};

    public GaussKrueger() {
        this(DEFAULT_ZONE);
    }

    public GaussKrueger(int n) {
        if (BETA2007 == null) {
            try {
                String string = "BETA2007.gsb";
                InputStream inputStream = Main.class.getResourceAsStream("/data/" + string);
                if (inputStream == null) {
                    throw new RuntimeException(I18n.tr("Error: failed to open input stream for resource ''/data/{0}''.", string));
                }
                BETA2007 = new NTV2GridShiftFile();
                BETA2007.loadGridShiftFile(inputStream, false);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.updateParameters(n);
    }

    private void updateParameters(int n) {
        this.zone = n;
        this.ellps = Ellipsoid.Bessel1841;
        this.nadgrids = BETA2007;
        this.proj = new TransverseMercator(this.ellps);
        this.x_0 = 1000000 * n + 500000;
        this.lon_0 = 3 * n;
    }

    @Override
    public String toString() {
        return I18n.tr("Gau\u00df-Kr\u00fcger", new Object[0]);
    }

    @Override
    public Integer getEpsgCode() {
        return 31464 + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "gausskrueger" + this.zone;
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return bounds[this.zone - 2];
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(zones);
        jComboBox.setSelectedIndex(this.zone - 2);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("GK Zone", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        int n = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(n + 2));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n = DEFAULT_ZONE;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((n = Integer.parseInt(string = iterator.next())) < 2 || n > 5)) {
                    n = DEFAULT_ZONE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.updateParameters(n);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[4];
        for (int i = 2; i <= 5; ++i) {
            stringArray[i - 2] = "EPSG:" + (31464 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (int i = 2; i <= 5; ++i) {
            String string2 = "EPSG:" + (31464 + i);
            if (!string2.equals(string)) continue;
            return Collections.singleton(String.valueOf(i));
        }
        return null;
    }
}

