/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeAction
extends JosmAction {
    public AbstractMergeAction() {
    }

    public AbstractMergeAction(String string, String string2, String string3, Shortcut shortcut, boolean bl) {
        super(string, string2, string3, shortcut, bl);
    }

    protected Layer askTargetLayer(List<Layer> list) {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setRenderer(new LayerListCellRenderer());
        jComboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        jComboBox.setSelectedIndex(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Please select the target layer.", new Object[0])), GBC.eol());
        jPanel.add(jComboBox, GBC.eol());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Select target layer", new Object[0]), new String[]{I18n.tr("Merge", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"dialogs/mergedown", "cancel"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return null;
        }
        Layer layer = (Layer)jComboBox.getSelectedItem();
        return layer;
    }

    protected void warnNoTargetLayersForSourceLayer(Layer layer) {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>There are no layers the source layer<br>''{0}''<br>could be merged to.</html>", new Object[0]), I18n.tr("No target layers", new Object[0]), 2);
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, layer.getName(), n, bl, bl2);
            Icon icon = layer.getIcon();
            jLabel.setIcon(icon);
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }
}

