/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.Stop;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.net.URI;
import java.util.ArrayList;

public abstract class Gradient
extends FillElement {
    public static final int SM_PAD = 0;
    public static final int SM_REPEAT = 1;
    public static final int SM_REFLECT = 2;
    int spreadMethod = 0;
    public static final int GU_OBJECT_BOUNDING_BOX = 0;
    public static final int GU_USER_SPACE_ON_USE = 1;
    protected int gradientUnits = 0;
    ArrayList stops = new ArrayList();
    URI stopRef = null;
    protected AffineTransform gradientTransform = null;
    float[] stopFractions;
    Color[] stopColors;

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
        if (!(sVGElement instanceof Stop)) {
            return;
        }
        this.appendStop((Stop)sVGElement);
    }

    protected void build() throws SVGException {
        String string;
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("spreadMethod"))) {
            string = styleAttribute.getStringValue().toLowerCase();
            this.spreadMethod = string.equals("repeat") ? 1 : (string.equals("reflect") ? 2 : 0);
        }
        if (this.getPres(styleAttribute.setName("gradientUnits"))) {
            string = styleAttribute.getStringValue().toLowerCase();
            this.gradientUnits = string.equals("userspaceonuse") ? 1 : 0;
        }
        if (this.getPres(styleAttribute.setName("gradientTransform"))) {
            this.gradientTransform = Gradient.parseTransform(styleAttribute.getStringValue());
        }
        if (this.gradientTransform == null) {
            this.gradientTransform = new AffineTransform();
        }
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            try {
                this.stopRef = styleAttribute.getURIValue(this.getXMLBase());
            }
            catch (Exception exception) {
                throw new SVGException("Could not resolve relative URL in Gradient: " + styleAttribute.getStringValue() + ", " + this.getXMLBase(), exception);
            }
        }
    }

    public float[] getStopFractions() {
        if (this.stopRef != null) {
            Gradient gradient = (Gradient)this.diagram.getUniverse().getElement(this.stopRef);
            return gradient.getStopFractions();
        }
        if (this.stopFractions != null) {
            return this.stopFractions;
        }
        this.stopFractions = new float[this.stops.size()];
        int n = 0;
        for (Stop stop : this.stops) {
            float f = stop.offset;
            if (n != 0 && f < this.stopFractions[n - 1]) {
                f = this.stopFractions[n - 1];
            }
            this.stopFractions[n++] = f;
        }
        return this.stopFractions;
    }

    public Color[] getStopColors() {
        if (this.stopRef != null) {
            Gradient gradient = (Gradient)this.diagram.getUniverse().getElement(this.stopRef);
            return gradient.getStopColors();
        }
        if (this.stopColors != null) {
            return this.stopColors;
        }
        this.stopColors = new Color[this.stops.size()];
        int n = 0;
        for (Stop stop : this.stops) {
            int n2 = stop.color.getRGB();
            Color color = new Color(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, this.clamp((int)(stop.opacity * 255.0f), 0, 255));
            this.stopColors[n++] = color;
        }
        return this.stopColors;
    }

    public void setStops(Color[] colorArray, float[] fArray) {
        if (colorArray.length != fArray.length) {
            throw new IllegalArgumentException();
        }
        this.stopColors = colorArray;
        this.stopFractions = fArray;
        this.stopRef = null;
    }

    private int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void setStopRef(URI uRI) {
        this.stopRef = uRI;
    }

    public void appendStop(Stop stop) {
        this.stops.add(stop);
    }

    public boolean updateTime(double d) throws SVGException {
        AffineTransform affineTransform;
        String string;
        int n;
        boolean bl = false;
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("spreadMethod")) && this.spreadMethod != (n = (string = styleAttribute.getStringValue().toLowerCase()).equals("repeat") ? 1 : (string.equals("reflect") ? 2 : 0))) {
            this.spreadMethod = n;
            bl = true;
        }
        if (this.getPres(styleAttribute.setName("gradientUnits")) && (n = (string = styleAttribute.getStringValue().toLowerCase()).equals("userspaceonuse") ? 1 : 0) != this.gradientUnits) {
            this.gradientUnits = n;
            bl = true;
        }
        if (this.getPres(styleAttribute.setName("gradientTransform")) && (affineTransform = Gradient.parseTransform(styleAttribute.getStringValue())) != null && affineTransform.equals(this.gradientTransform)) {
            this.gradientTransform = affineTransform;
            bl = true;
        }
        if (this.getPres(styleAttribute.setName("xlink:href"))) {
            try {
                URI uRI = styleAttribute.getURIValue(this.getXMLBase());
                if (uRI == null && this.stopRef != null || !uRI.equals(this.stopRef)) {
                    this.stopRef = uRI;
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (Stop stop : this.stops) {
            if (!stop.updateTime(d)) continue;
            bl = true;
            this.stopFractions = null;
            this.stopColors = null;
        }
        return bl;
    }
}

