/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTagsDialog
extends ExtendedDialog
implements SelectionChangedListener {
    private final JTable propertyTable;
    private Collection<? extends OsmPrimitive> sel;
    boolean[] existing;

    public AddTagsDialog(String[][] stringArray) {
        super(Main.parent, I18n.tr("Add tags to selected objects", new Object[0]), new String[]{I18n.tr("Add tags", new Object[0]), I18n.tr("Cancel", new Object[0])}, false, true);
        DataSet.addSelectionListener(this);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{I18n.tr("Assume", new Object[0]), I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])}, stringArray.length){

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }
        };
        this.sel = Main.main.getCurrentDataSet().getSelected();
        this.existing = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.existing[i] = false;
            String string = stringArray[i][0];
            Boolean bl = Boolean.TRUE;
            for (OsmPrimitive osmPrimitive : this.sel) {
                if (!osmPrimitive.keySet().contains(string)) continue;
                bl = Boolean.FALSE;
                this.existing[i] = true;
                break;
            }
            defaultTableModel.setValueAt(bl, i, 0);
            defaultTableModel.setValueAt(stringArray[i][0], i, 1);
            defaultTableModel.setValueAt(stringArray[i][1], i, 2);
        }
        this.propertyTable = new JTable(defaultTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (AddTagsDialog.this.existing[n]) {
                    component.setFont(component.getFont().deriveFont(2));
                    component.setForeground(new Color(100, 100, 100));
                } else {
                    component.setFont(component.getFont().deriveFont(0));
                    component.setForeground(new Color(0, 0, 0));
                }
                return component;
            }
        };
        this.propertyTable.getColumnModel().getColumn(0).setMaxWidth(15);
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        this.setContent(jPanel);
        this.setPreferredSize(new Dimension(400, jPanel.getPreferredSize().height + 100));
        this.showDialog();
    }

    private void findExistingTags() {
        TableModel tableModel = this.propertyTable.getModel();
        block0: for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 1);
            this.existing[i] = false;
            for (OsmPrimitive osmPrimitive : this.sel) {
                if (!osmPrimitive.keySet().contains(string)) continue;
                this.existing[i] = true;
                continue block0;
            }
        }
        this.propertyTable.repaint();
    }

    @Override
    protected void buttonAction(int n, ActionEvent actionEvent) {
        if (n == 0) {
            TableModel tableModel = this.propertyTable.getModel();
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                if (!((Boolean)tableModel.getValueAt(i, 0)).booleanValue()) continue;
                Main.main.undoRedo.add(new ChangePropertyCommand(this.sel, (String)tableModel.getValueAt(i, 1), (String)tableModel.getValueAt(i, 2)));
            }
        }
        this.setVisible(false);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.sel = collection;
        this.findExistingTags();
    }
}

