/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.preferences.AddWMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.io.imagery.HTMLGrabber;
import org.openstreetmap.josm.io.imagery.OffsetServer;
import org.openstreetmap.josm.io.imagery.OsmosnimkiOffsetServer;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryPreference
implements PreferenceSetting {
    ImageryProvidersPanel imageryProviders;
    ImageryLayerInfo layerInfo;
    private Color colFadeColor;
    private JButton btnFadeColor;
    private JSlider fadeAmount = new JSlider(0, 100);
    private JComboBox sharpen;
    private JCheckBox useOffsetServer;
    private JTextField offsetServerUrl;
    private JComboBox browser;
    JCheckBox overlapCheckBox;
    JSpinner spinEast;
    JSpinner spinNorth;
    JSpinner spinSimConn;
    private JCheckBox autozoomActive = new JCheckBox();
    private JCheckBox autoloadTiles = new JCheckBox();
    private JSpinner minZoomLvl;
    private JSpinner maxZoomLvl;
    private JCheckBox addToSlippyMapChosser = new JCheckBox();
    private JTextField tilecacheDir = new JTextField();

    private JPanel buildCommonSettingsPanel(final PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.colFadeColor = ImageryLayer.getFadeColor();
        this.btnFadeColor = new JButton();
        this.btnFadeColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(ImageryPreference.this.colFadeColor);
                int n = JOptionPane.showConfirmDialog(preferenceTabbedPane, jColorChooser, I18n.tr("Choose a color for {0}", I18n.tr("imagery fade", new Object[0])), 2, -1);
                if (n == 0) {
                    ImageryPreference.this.colFadeColor = jColorChooser.getColor();
                    ImageryPreference.this.btnFadeColor.setBackground(ImageryPreference.this.colFadeColor);
                    ImageryPreference.this.btnFadeColor.setText(ColorHelper.color2html(ImageryPreference.this.colFadeColor));
                }
            }
        });
        jPanel.add((Component)new JLabel(I18n.tr("Fade Color: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Fade amount: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.sharpen = new JComboBox<String>(new String[]{I18n.tr("None", new Object[0]), I18n.tr("Soft", new Object[0]), I18n.tr("Strong", new Object[0])});
        jPanel.add(new JLabel(I18n.tr("Sharpen (requires layer re-add): ", new Object[0])));
        jPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        jPanel.add((Component)this.sharpen, GBC.eol().fill(2));
        this.useOffsetServer = new JCheckBox(I18n.tr("Use offset server: ", new Object[0]));
        this.offsetServerUrl = new JTextField();
        this.useOffsetServer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ImageryPreference.this.offsetServerUrl.setEnabled(ImageryPreference.this.useOffsetServer.isSelected());
            }
        });
        this.offsetServerUrl.setEnabled(this.useOffsetServer.isSelected());
        jPanel.add((Component)this.useOffsetServer, GBC.eol().fill(2));
        jPanel.add((Component)this.offsetServerUrl, GBC.eol().fill(2));
        return jPanel;
    }

    private JPanel buildWMSSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.browser = new JComboBox<String>(new String[]{"webkit-image {0}", "gnome-web-photo --mode=photo --format=png {0} /dev/stdout", "gnome-web-photo-fixed {0}", "webkit-image-gtk {0}"});
        this.browser.setEditable(true);
        jPanel.add((Component)new JLabel(I18n.tr("Downloader:", new Object[0])), GBC.eol().fill(2));
        jPanel.add(this.browser);
        jPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        this.overlapCheckBox = new JCheckBox(I18n.tr("Overlap tiles", new Object[0]));
        JLabel jLabel = new JLabel(I18n.tr("% of east:", new Object[0]));
        JLabel jLabel2 = new JLabel(I18n.tr("% of north:", new Object[0]));
        this.spinEast = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_EAST.get(), 1, 50, 1));
        this.spinNorth = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_OVERLAP_NORTH.get(), 1, 50, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.overlapCheckBox);
        jPanel2.add(jLabel);
        jPanel2.add(this.spinEast);
        jPanel2.add(jLabel2);
        jPanel2.add(this.spinNorth);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel jLabel3 = new JLabel(I18n.tr("Simultaneous connections", new Object[0]));
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get(), 1, 30, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(jLabel3);
        jPanel3.add(this.spinSimConn);
        jPanel.add((Component)jPanel3, GBC.eol().fill(2));
        return jPanel;
    }

    private JPanel buildTMSSettingsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.minZoomLvl = new JSpinner(new SpinnerNumberModel(2, 2, 30, 1));
        this.maxZoomLvl = new JSpinner(new SpinnerNumberModel(20, 2, 30, 1));
        jPanel.add((Component)new JLabel(I18n.tr("Auto zoom by default: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.autozoomActive, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Autoload tiles by default: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.autoloadTiles, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Min. zoom level: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.minZoomLvl, GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Max. zoom level: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.maxZoomLvl, GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Add to slippymap chooser: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.addToSlippyMapChosser, GBC.eol().fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Tile cache directory: ", new Object[0])), GBC.std());
        jPanel.add(GBC.glue(5, 0), GBC.std());
        jPanel.add((Component)this.tilecacheDir, GBC.eol().fill(2));
        return jPanel;
    }

    private void addSettingsSection(JPanel jPanel, String string, JPanel jPanel2) {
        this.addSettingsSection(jPanel, string, jPanel2, GBC.eol());
    }

    private void addSettingsSection(JPanel jPanel, String string, JPanel jPanel2, GBC gBC) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        jPanel.add((Component)jPanel2, gBC.insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addSettingsSection(jPanel, I18n.tr("Common Settings", new Object[0]), this.buildCommonSettingsPanel(preferenceTabbedPane));
        this.addSettingsSection(jPanel, I18n.tr("WMS Settings", new Object[0]), this.buildWMSSettingsPanel());
        this.addSettingsSection(jPanel, I18n.tr("TMS Settings", new Object[0]), this.buildTMSSettingsPanel(), GBC.eol().fill(2));
        jPanel.add((Component)new JPanel(), GBC.eol().fill(1));
        return new JScrollPane(jPanel);
    }

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = preferenceTabbedPane.createPreferenceTab("imagery", I18n.tr("Imagery Preferences", new Object[0]), I18n.tr("Modify list of imagery layers displayed in the Imagery menu", new Object[0]));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.layerInfo = new ImageryLayerInfo(ImageryLayerInfo.instance);
        this.imageryProviders = new ImageryProvidersPanel(preferenceTabbedPane, this.layerInfo);
        jTabbedPane.add(this.imageryProviders);
        jTabbedPane.add(this.buildSettingsPanel(preferenceTabbedPane));
        jTabbedPane.add(new OffsetBookmarksPanel(preferenceTabbedPane));
        this.loadSettings();
        jTabbedPane.setTitleAt(0, I18n.tr("Imagery providers", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Settings", new Object[0]));
        jTabbedPane.setTitleAt(2, I18n.tr("Offset bookmarks", new Object[0]));
        jPanel.add((Component)jTabbedPane, GBC.std().fill(1));
    }

    private void loadSettings() {
        this.btnFadeColor.setBackground(this.colFadeColor);
        this.btnFadeColor.setText(ColorHelper.color2html(this.colFadeColor));
        this.fadeAmount.setValue(ImageryLayer.PROP_FADE_AMOUNT.get());
        this.sharpen.setSelectedIndex(Math.max(0, Math.min(2, ImageryLayer.PROP_SHARPEN_LEVEL.get())));
        this.useOffsetServer.setSelected(OffsetServer.PROP_SERVER_ENABLED.get());
        this.offsetServerUrl.setText(OsmosnimkiOffsetServer.PROP_SERVER_URL.get());
        this.browser.setSelectedItem(HTMLGrabber.PROP_BROWSER.get());
        this.overlapCheckBox.setSelected(WMSLayer.PROP_OVERLAP.get());
        this.spinEast.setValue(WMSLayer.PROP_OVERLAP_EAST.get());
        this.spinNorth.setValue(WMSLayer.PROP_OVERLAP_NORTH.get());
        this.spinSimConn.setValue(WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.get());
        this.autozoomActive.setSelected(TMSLayer.PROP_DEFAULT_AUTOZOOM.get());
        this.autoloadTiles.setSelected(TMSLayer.PROP_DEFAULT_AUTOLOAD.get());
        this.addToSlippyMapChosser.setSelected(TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get());
        this.maxZoomLvl.setValue(TMSLayer.getMaxZoomLvl(null));
        this.minZoomLvl.setValue(TMSLayer.getMinZoomLvl(null));
        this.tilecacheDir.setText(TMSLayer.PROP_TILECACHE_DIR.get());
    }

    public boolean ok() {
        boolean bl = false;
        this.layerInfo.save();
        ImageryLayerInfo.instance.clear();
        ImageryLayerInfo.instance.load();
        Main.main.menu.imageryMenu.refreshImageryMenu();
        Main.main.menu.imageryMenu.refreshOffsetMenu();
        OffsetBookmark.saveBookmarks();
        WMSLayer.PROP_OVERLAP.put(this.overlapCheckBox.getModel().isSelected());
        WMSLayer.PROP_OVERLAP_EAST.put((Integer)this.spinEast.getModel().getValue());
        WMSLayer.PROP_OVERLAP_NORTH.put((Integer)this.spinNorth.getModel().getValue());
        WMSLayer.PROP_SIMULTANEOUS_CONNECTIONS.put((Integer)this.spinSimConn.getModel().getValue());
        HTMLGrabber.PROP_BROWSER.put(this.browser.getEditor().getItem().toString());
        OffsetServer.PROP_SERVER_ENABLED.put(this.useOffsetServer.isSelected());
        OsmosnimkiOffsetServer.PROP_SERVER_URL.put(this.offsetServerUrl.getText());
        if (TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get() != this.addToSlippyMapChosser.isSelected()) {
            bl = true;
        }
        TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.put(this.addToSlippyMapChosser.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        TMSLayer.PROP_DEFAULT_AUTOLOAD.put(this.autoloadTiles.isSelected());
        TMSLayer.setMaxZoomLvl((Integer)this.maxZoomLvl.getValue());
        TMSLayer.setMinZoomLvl((Integer)this.minZoomLvl.getValue());
        TMSLayer.PROP_TILECACHE_DIR.put(this.tilecacheDir.getText());
        ImageryLayer.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryLayer.setFadeColor(this.colFadeColor);
        ImageryLayer.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        return bl;
    }

    public void setServerUrl(String string, String string2) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.model.setValueAt(string2, i, 1);
            return;
        }
        this.imageryProviders.model.addRow(new String[]{string, string2});
    }

    public String getServerUrl(String string) {
        for (int i = 0; i < this.imageryProviders.model.getRowCount(); ++i) {
            if (!string.equals(this.imageryProviders.model.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.model.getValueAt(i, 1).toString();
        }
        return null;
    }

    public static void initialize() {
        ImageryLayerInfo.instance.clear();
        ImageryLayerInfo.instance.loadDefaults(false);
        ImageryLayerInfo.instance.load();
        OffsetBookmark.loadBookmarks();
        Main.main.menu.imageryMenu.refreshImageryMenu();
        Main.main.menu.imageryMenu.refreshOffsetMenu();
    }

    static class OffsetBookmarksPanel
    extends JPanel {
        List<OffsetBookmark> bookmarks = OffsetBookmark.allBookmarks;
        OffsetsBookmarksModel model = new OffsetsBookmarksModel();

        public OffsetBookmarksPanel(final PreferenceTabbedPane preferenceTabbedPane) {
            super(new GridBagLayout());
            final JTable jTable = new JTable(this.model){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return OffsetBookmarksPanel.this.model.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.add((Component)jScrollPane, GBC.eol().fill(1));
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(150);
            tableColumnModel.getColumn(1).setPreferredWidth(200);
            tableColumnModel.getColumn(2).setPreferredWidth(300);
            tableColumnModel.getColumn(3).setPreferredWidth(150);
            tableColumnModel.getColumn(4).setPreferredWidth(150);
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
            jPanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OffsetBookmark offsetBookmark = new OffsetBookmark(Main.getProjection(), "", "", 0.0, 0.0);
                    OffsetBookmarksPanel.this.model.addRow(offsetBookmark);
                }
            });
            JButton jButton2 = new JButton(I18n.tr("Delete", new Object[0]));
            jPanel.add((Component)jButton2, GBC.std().insets(0, 5, 0, 0));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jTable.getSelectedRow() == -1) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete.", new Object[0]));
                    } else {
                        Integer n;
                        while ((n = Integer.valueOf(jTable.getSelectedRow())) != -1) {
                            OffsetBookmarksPanel.this.model.removeRow(n);
                        }
                    }
                }
            });
            this.add((Component)jPanel, GBC.eol());
        }

        class OffsetsBookmarksModel
        extends DefaultTableModel {
            public OffsetsBookmarksModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Projection", new Object[0]), I18n.tr("Layer", new Object[0]), I18n.tr("Name", new Object[0]), I18n.tr("Easting", new Object[0]), I18n.tr("Northing", new Object[0])});
            }

            public OffsetBookmark getRow(int n) {
                return OffsetBookmarksPanel.this.bookmarks.get(n);
            }

            public void addRow(OffsetBookmark offsetBookmark) {
                OffsetBookmarksPanel.this.bookmarks.add(offsetBookmark);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            public void removeRow(int n) {
                OffsetBookmarksPanel.this.bookmarks.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            public int getRowCount() {
                return OffsetBookmarksPanel.this.bookmarks.size();
            }

            public Object getValueAt(int n, int n2) {
                OffsetBookmark offsetBookmark = OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 0: {
                        if (offsetBookmark.proj == null) {
                            return "";
                        }
                        return ((Object)offsetBookmark.proj).toString();
                    }
                    case 1: {
                        return offsetBookmark.layerName;
                    }
                    case 2: {
                        return offsetBookmark.name;
                    }
                    case 3: {
                        return offsetBookmark.dx;
                    }
                    case 4: {
                        return offsetBookmark.dy;
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            public void setValueAt(Object object, int n, int n2) {
                OffsetBookmark offsetBookmark = OffsetBookmarksPanel.this.bookmarks.get(n);
                switch (n2) {
                    case 1: {
                        offsetBookmark.layerName = object.toString();
                        break;
                    }
                    case 2: {
                        offsetBookmark.name = object.toString();
                        break;
                    }
                    case 3: {
                        offsetBookmark.dx = Double.parseDouble((String)object);
                        break;
                    }
                    case 4: {
                        offsetBookmark.dy = Double.parseDouble((String)object);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 >= 1;
            }
        }
    }

    static class ImageryProvidersPanel
    extends JPanel {
        final ImageryLayerTableModel model;
        final ImageryDefaultLayerTableModel modeldef;
        private final ImageryLayerInfo layerInfo;
        private JTable listActive;
        final JTable listdef;
        final JMapViewer map;
        final PreferenceTabbedPane gui;

        public ImageryProvidersPanel(PreferenceTabbedPane preferenceTabbedPane, ImageryLayerInfo imageryLayerInfo) {
            super(new GridBagLayout());
            this.gui = preferenceTabbedPane;
            this.layerInfo = imageryLayerInfo;
            this.model = new ImageryLayerTableModel();
            this.listActive = new JTable(this.model){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return ImageryProvidersPanel.this.model.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point)).toString();
                }
            };
            this.modeldef = new ImageryDefaultLayerTableModel();
            this.listdef = new JTable(this.modeldef){

                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    return (String)ImageryProvidersPanel.this.modeldef.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point));
                }
            };
            this.modeldef.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    ImageryProvidersPanel.this.listActive.repaint();
                }
            });
            this.model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    ImageryProvidersPanel.this.listdef.repaint();
                }
            });
            TableColumnModel tableColumnModel = this.listdef.getColumnModel();
            tableColumnModel.getColumn(2).setPreferredWidth(800);
            tableColumnModel.getColumn(2).setCellRenderer(new ImageryTableCellRenderer(this.layerInfo.getLayers()));
            tableColumnModel.getColumn(1).setPreferredWidth(400);
            tableColumnModel.getColumn(0).setPreferredWidth(50);
            tableColumnModel = this.listActive.getColumnModel();
            tableColumnModel.getColumn(1).setPreferredWidth(800);
            tableColumnModel.getColumn(1).setCellRenderer(new ImageryTableCellRenderer(this.layerInfo.getDefaultLayers()));
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            RemoveEntryAction removeEntryAction = new RemoveEntryAction();
            this.listActive.getSelectionModel().addListSelectionListener(removeEntryAction);
            this.add((Component)new JLabel(I18n.tr("Available default entries:", new Object[0])), GBC.eol().insets(5, 5, 0, 0));
            JScrollPane jScrollPane = new JScrollPane(this.listdef);
            jScrollPane.setPreferredSize(new Dimension(200, 200));
            this.add((Component)jScrollPane, GBC.std().insets(0, 5, 0, 0).fill(1).weight(1.0, 0.6).insets(5, 0, 0, 0));
            this.map = new JMapViewer();
            this.map.setZoomContolsVisible(false);
            this.map.setMinimumSize(new Dimension(100, 200));
            this.add((Component)this.map, GBC.std().insets(5, 5, 0, 0).fill(1).weight(0.33, 0.6).insets(5, 0, 0, 0));
            this.listdef.getSelectionModel().addListSelectionListener(new DefListSelectionListener());
            JToolBar jToolBar = new JToolBar(1);
            jToolBar.setFloatable(false);
            jToolBar.setBorderPainted(false);
            jToolBar.setOpaque(false);
            jToolBar.add(new ReloadAction());
            this.add((Component)jToolBar, GBC.eol().anchor(15).insets(0, 0, 5, 0));
            ActivateAction activateAction = new ActivateAction();
            this.listdef.getSelectionModel().addListSelectionListener(activateAction);
            JButton jButton = new JButton(activateAction);
            JToolBar jToolBar2 = new JToolBar(1);
            jToolBar2.setFloatable(false);
            jToolBar2.setBorderPainted(false);
            jToolBar2.setOpaque(false);
            jToolBar2.add(jButton);
            this.add((Component)jToolBar2, GBC.eol().anchor(10).insets(5, 15, 5, 0));
            this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
            this.add((Component)new JLabel(I18n.tr("Selected entries:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
            JScrollPane jScrollPane2 = new JScrollPane(this.listActive);
            this.add((Component)jScrollPane2, GBC.std().fill(1).span(-1).weight(1.0, 0.4).insets(5, 0, 0, 5));
            jScrollPane2.setPreferredSize(new Dimension(200, 200));
            JToolBar jToolBar3 = new JToolBar(1);
            jToolBar3.setFloatable(false);
            jToolBar3.setBorderPainted(false);
            jToolBar3.setOpaque(false);
            jToolBar3.add(new NewEntryAction());
            jToolBar3.add(removeEntryAction);
            this.add((Component)jToolBar3, GBC.eol().anchor(11).insets(0, 0, 5, 5));
        }

        private boolean confirmEulaAcceptance(PreferenceTabbedPane preferenceTabbedPane, String string) {
            URL uRL = null;
            try {
                uRL = new URL(string.replaceAll("\\{lang\\}", Locale.getDefault().toString()));
                JEditorPane jEditorPane = null;
                try {
                    jEditorPane = new JEditorPane(uRL);
                }
                catch (IOException iOException) {
                    try {
                        uRL = new URL(string.replaceAll("\\{lang\\}", "en"));
                        jEditorPane = new JEditorPane(uRL);
                    }
                    catch (IOException iOException2) {
                        JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("EULA license URL not available: {0}", string));
                        return false;
                    }
                }
                Box box = Box.createVerticalBox();
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                jScrollPane.setPreferredSize(new Dimension(400, 400));
                box.add(jScrollPane);
                int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Please abort if you are not sure", new Object[0]), 0, 2);
                if (n == 0) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Malformed URL for the EULA licence: {0}", string));
            }
            return false;
        }

        class ImageryDefaultLayerTableModel
        extends DefaultTableModel {
            public ImageryDefaultLayerTableModel() {
                this.setColumnIdentifiers(new String[]{"", I18n.tr("Menu Name (Default)", new Object[0]), I18n.tr("Imagery URL (Default)", new Object[0])});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getDefaultLayers().get(n);
            }

            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getDefaultLayers().size();
            }

            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getDefaultLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getCountryCode();
                    }
                    case 1: {
                        return imageryInfo.getName();
                    }
                    case 2: {
                        return imageryInfo.getExtendedUrl();
                    }
                }
                return null;
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }

        class ImageryLayerTableModel
        extends DefaultTableModel {
            public ImageryLayerTableModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name", new Object[0]), I18n.tr("Imagery URL", new Object[0])});
            }

            public ImageryInfo getRow(int n) {
                return ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
            }

            public void addRow(ImageryInfo imageryInfo) {
                ImageryProvidersPanel.this.layerInfo.add(imageryInfo);
                int n = this.getRowCount() - 1;
                this.fireTableRowsInserted(n, n);
            }

            public void removeRow(int n) {
                ImageryProvidersPanel.this.layerInfo.remove(this.getRow(n));
                this.fireTableRowsDeleted(n, n);
            }

            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getLayers().size();
            }

            public Object getValueAt(int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        return imageryInfo.getName();
                    }
                    case 1: {
                        return imageryInfo.getExtendedUrl();
                    }
                }
                throw new ArrayIndexOutOfBoundsException();
            }

            public void setValueAt(Object object, int n, int n2) {
                ImageryInfo imageryInfo = ImageryProvidersPanel.this.layerInfo.getLayers().get(n);
                switch (n2) {
                    case 0: {
                        imageryInfo.setName((String)object);
                        break;
                    }
                    case 1: {
                        imageryInfo.setExtendedUrl((String)object);
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }
            }

            public boolean isCellEditable(int n, int n2) {
                return true;
            }
        }

        class ReloadAction
        extends AbstractAction {
            public ReloadAction() {
                this.putValue("ShortDescription", I18n.tr("reload defaults", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ImageryProvidersPanel.this.layerInfo.loadDefaults(true);
                ImageryProvidersPanel.this.modeldef.fireTableDataChanged();
            }
        }

        class ActivateAction
        extends AbstractAction
        implements ListSelectionListener {
            public ActivateAction() {
                this.putValue("Name", I18n.tr("Activate", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("copy selected defaults", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("preferences", "activate-down"));
            }

            protected void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.listdef.getSelectedRowCount() > 0);
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.updateEnabledState();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ImageryProvidersPanel.this.listdef.getSelectedRows();
                if (nArray.length == 0) {
                    JOptionPane.showMessageDialog(ImageryProvidersPanel.this.gui, I18n.tr("Please select at least one row to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return;
                }
                HashSet<String> hashSet = new HashSet<String>();
                block0: for (int i = 0; i < nArray.length; ++i) {
                    ImageryInfo imageryInfo = ImageryProvidersPanel.this.modeldef.getRow(nArray[i]);
                    for (int j = 0; j < ImageryProvidersPanel.this.model.getRowCount(); ++j) {
                        if (!imageryInfo.equalsBaseValues(ImageryProvidersPanel.this.model.getRow(j))) continue;
                        ImageryProvidersPanel.this.listActive.getSelectionModel().setSelectionInterval(j, j);
                        ImageryProvidersPanel.this.listActive.scrollRectToVisible(ImageryProvidersPanel.this.listActive.getCellRect(j, 0, true));
                        continue block0;
                    }
                    String string = imageryInfo.getEulaAcceptanceRequired();
                    if (string != null && !hashSet.contains(string)) {
                        if (!ImageryProvidersPanel.this.confirmEulaAcceptance(ImageryProvidersPanel.this.gui, string)) continue;
                        hashSet.add(string);
                    }
                    ImageryProvidersPanel.this.model.addRow(new ImageryInfo(imageryInfo));
                    int n = ImageryProvidersPanel.this.model.getRowCount() - 1;
                    ImageryProvidersPanel.this.listActive.getSelectionModel().setSelectionInterval(n, n);
                    ImageryProvidersPanel.this.listActive.scrollRectToVisible(ImageryProvidersPanel.this.listActive.getCellRect(n, 0, true));
                }
            }
        }

        class RemoveEntryAction
        extends AbstractAction
        implements ListSelectionListener {
            public RemoveEntryAction() {
                this.putValue("Name", I18n.tr("Remove", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Remove entry", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
                this.updateEnabledState();
            }

            protected void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.listActive.getSelectedRowCount() > 0);
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.updateEnabledState();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Integer n;
                while ((n = Integer.valueOf(ImageryProvidersPanel.this.listActive.getSelectedRow())) != -1) {
                    ImageryProvidersPanel.this.model.removeRow(n);
                }
            }
        }

        class NewEntryAction
        extends AbstractAction {
            public NewEntryAction() {
                this.putValue("Name", I18n.tr("New", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Add a new WMS/TMS entry by entering the URL", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                final AddWMSLayerPanel addWMSLayerPanel = new AddWMSLayerPanel();
                addWMSLayerPanel.addHierarchyListener(new HierarchyListener(){

                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        Dialog dialog;
                        Window window = SwingUtilities.getWindowAncestor(addWMSLayerPanel);
                        if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                            dialog.setResizable(true);
                            dialog.setMinimumSize(new Dimension(250, 350));
                        }
                    }
                });
                int n = JOptionPane.showConfirmDialog(ImageryProvidersPanel.this.gui, addWMSLayerPanel, I18n.tr("Add Imagery URL", new Object[0]), 2, -1);
                if (n == 0) {
                    try {
                        ImageryInfo imageryInfo = new ImageryInfo(addWMSLayerPanel.getUrlName(), addWMSLayerPanel.getUrl());
                        if (ImageryInfo.ImageryType.TMS.equals((Object)imageryInfo.getImageryType())) {
                            TMSLayer.checkUrl(imageryInfo.getUrl());
                        }
                        ImageryProvidersPanel.this.model.addRow(imageryInfo);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) {
                            throw illegalArgumentException;
                        }
                        JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
                    }
                }
            }
        }

        private final class DefListSelectionListener
        implements ListSelectionListener {
            private final Map<Integer, MapRectangle> mapRectangles = new HashMap<Integer, MapRectangle>();
            private final Map<Integer, List<MapPolygon>> mapPolygons = new HashMap<Integer, List<MapPolygon>>();

            private DefListSelectionListener() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getFirstIndex() == -1) {
                    ImageryProvidersPanel.this.map.removeAllMapRectangles();
                    ImageryProvidersPanel.this.map.removeAllMapPolygons();
                    this.mapRectangles.clear();
                    this.mapPolygons.clear();
                } else if (!listSelectionEvent.getValueIsAdjusting()) {
                    for (int i = listSelectionEvent.getFirstIndex(); i <= listSelectionEvent.getLastIndex(); ++i) {
                        this.updateBoundsAndShapes(i);
                    }
                    if (!this.mapRectangles.isEmpty() || !this.mapPolygons.isEmpty()) {
                        ImageryProvidersPanel.this.map.setDisplayToFitMapElements(false, true, true);
                        ImageryProvidersPanel.this.map.zoomOut();
                    }
                }
            }

            private void updateBoundsAndShapes(int n) {
                ImageryInfo.ImageryBounds imageryBounds = ImageryProvidersPanel.this.modeldef.getRow(n).getBounds();
                if (imageryBounds != null) {
                    List<Shape> list = imageryBounds.getShapes();
                    if (list != null && !list.isEmpty()) {
                        if (ImageryProvidersPanel.this.listdef.getSelectionModel().isSelectedIndex(n)) {
                            if (!this.mapPolygons.containsKey(n)) {
                                ArrayList<MapPolygonImpl> arrayList = new ArrayList<MapPolygonImpl>();
                                this.mapPolygons.put(n, arrayList);
                                for (Shape shape : list) {
                                    MapPolygonImpl mapPolygonImpl = new MapPolygonImpl(shape.getPoints());
                                    arrayList.add(mapPolygonImpl);
                                    ImageryProvidersPanel.this.map.addMapPolygon(mapPolygonImpl);
                                }
                            }
                        } else if (this.mapPolygons.containsKey(n)) {
                            for (MapPolygon mapPolygon : this.mapPolygons.get(n)) {
                                ImageryProvidersPanel.this.map.removeMapPolygon(mapPolygon);
                            }
                            this.mapPolygons.remove(n);
                        }
                    } else if (ImageryProvidersPanel.this.listdef.getSelectionModel().isSelectedIndex(n)) {
                        if (!this.mapRectangles.containsKey(n)) {
                            Coordinate coordinate = new Coordinate(imageryBounds.getMax().lat(), imageryBounds.getMin().lon());
                            Coordinate coordinate2 = new Coordinate(imageryBounds.getMin().lat(), imageryBounds.getMax().lon());
                            MapRectangleImpl mapRectangleImpl = new MapRectangleImpl(coordinate, coordinate2);
                            this.mapRectangles.put(n, mapRectangleImpl);
                            ImageryProvidersPanel.this.map.addMapRectangle(mapRectangleImpl);
                        }
                    } else if (this.mapRectangles.containsKey(n)) {
                        ImageryProvidersPanel.this.map.removeMapRectangle(this.mapRectangles.get(n));
                        this.mapRectangles.remove(n);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ImageryTableCellRenderer
        extends DefaultTableCellRenderer {
            private List<ImageryInfo> layers;

            public ImageryTableCellRenderer(List<ImageryInfo> list) {
                this.layers = list;
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                String string = object.toString();
                jLabel.setBackground(Main.pref.getUIColor("Table.background"));
                if (bl) {
                    jLabel.setForeground(Main.pref.getUIColor("Table.foreground"));
                }
                for (ImageryInfo imageryInfo : this.layers) {
                    if (!imageryInfo.getExtendedUrl().equals(string)) continue;
                    jLabel.setBackground(Main.pref.getColor(I18n.marktr("Imagery Background: Default"), new Color(200, 255, 200)));
                    break;
                }
                return jLabel;
            }
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ImageryPreference();
        }
    }
}

